# RGSSCurhc[
# Copyright (C) 2005 Y.Fukuyama

require 'kconv'

class Builder
  class Section
    attr :name
    attr :tree
    def initialize(name)
      @name = name
      @tree = []
    end
    def add_section(section)
      return @tree.push(section)
    end
    def get_section(name)
      @tree.each do |s|
        return s if s.name == name
      end
      return nil
    end
    def add_tree_section(list)
      return if list.empty?
      name = list.shift
      section = get_section(name)
      if section.nil?
         section = Section.new(name)
         add_section(section)
         section.add_tree_section(list)
      else
         section.add_tree_section(list)
      end
    end
  end

  #--------------------------------------------------------------------------
  # 
  #--------------------------------------------------------------------------
  def initialize(src_dir)
    @src_dir = src_dir
  end
  #--------------------------------------------------------------------------
  # \GfB^tH[}bgɂ܂Ƃ߂
  #--------------------------------------------------------------------------
  def build_sted(target_name,src_data)
    filenames = nil
    case src_data
    when Array
      filenames = src_data
    when String
      if FileTest.file? src_data
        filenames = []
        open(src_data).each do |line|
          filenames.push line.chop
        end
      end
    end
    create_sections filenames
    write_sted_format target_name
  end
  #--------------------------------------------------------------------------
  # ZNV̍쐬
  #--------------------------------------------------------------------------
  def create_sections(filenames)
    @section = Section.new(@src_dir)
    filenames.each do |filename|
      @section.add_tree_section filename.split(/[\\\/]/)
    end
  end
  #--------------------------------------------------------------------------
  # \GfB^tH[}bgŏ
  #--------------------------------------------------------------------------
  def write_sted_format(output_file)
    @out = open(output_file,'w')
    _write_sted_format @section
    @out.write "\n"
    @out.close
  end
  def _write_sted_format(section,dir='')
    current = dir + section.name
    if current != '.'
	    # ZNV
	    @out.write '# ' + section.name + " \n"


	    # t@C
	    if FileTest.file?(current)
	      open(current).each do |line|
	        line.sub(/[ \t\n]*$/,"\n")
	        @out.write line
	      end
	    elsif FileTest.directory?(current)
	      if FileTest.exist?(current + '/package.txt')
	        open(current + '/package.txt').each do |line|
	          line.sub(/[ \t\n]*$/,"\n")
	          @out.write line
	        end
	      end
	    end
	    # qZNV
	    if not section.tree.empty?
	      @out.write "\t"
	      section.tree.each do |child|
	        @out.write "\n"
	        _write_sted_format(child, current + '/')
	      end
	    end
	    # ZNV
	    @out.write " "
    else
	    top = true
	    # qZNV
	    if not section.tree.empty?
	      section.tree.each do |child|
	        @out.write "\n" if not top
	        _write_sted_format(child, current + '/')
            top = false
	      end
	    end
    end
  end
end

begin
  builder = Builder.new(".")
#  builder.build_sted("map_loop.sted","map_loop.txt")
  builder.build_sted("train_actor.sted","train_actor.txt")
end
