module Make_RPG
  MAKE_DIR_LIST = []
  EVENT_CREATE_FORCE = false
  LOG_LEVEL = "info"
  LOG_FILE = nil
end

if ENV.include? 'RPG_MAKE_FILE'
  $makefile = ENV['RPG_MAKE_FILE']
else
  $makefile = "#{Dir.pwd}/game.rxmk"
end

if FileTest.file?($makefile)
  IO.foreach($makefile) do |line|
    if line =~ /^#/
      next
    end
    key,value = line.split(/=/,2).collect {|s| s.strip}
    case key
    when "MAKE_DIR_LIST"
      values = value.split(/,/).collect {|s| s.strip}
      Make_RPG.const_set(key,values)
    when "EVENT_CREATE_FORCE"
      Event_Compiler.const_set(key,value == "true")
    when "LOG_LEVEL"
      Make_RPG.const_set(key,value)
    when "LOG_FILE"
      Make_RPG.const_set(key,value)
    end
  end
else
  p "game.rxmk t@C܂"
  exit
end

module Event_Compiler
  
  # OW[
  module Log
    self.log_level = Make_RPG::LOG_LEVEL
    module_function
    def output(msg)
      if msg =~ /^ERROR/
        Window_Console.put(msg,Color.new(255,0,0,255))
        now = Time.now
        # Oɏ
        File.open(now.strftime("makerpg_error_%Y%m%d_log.txt"), "a+") do |file|
          file.puts now.strftime("%Y/%m/%d %H:%M:%S ") + msg
        end
      elsif msg =~ /^DEBUG/
        Window_Console.put(msg,Color.new(0,255,255,255))
      else
        Window_Console.put(msg)
      end
      unless Make_RPG::LOG_FILE.nil?
        # Oɏ
        File.open(Make_RPG::LOG_FILE, "a+") do |file|
          file.puts Time.now.strftime("%Y/%m/%d %H:%M:%S ") + msg
        end
      end
      update_wait
    end
    def update_wait
      while Window_Console.output?
        Graphics.update
        Input.update
        if $scene.nil?
          break
        end
        $scene.update
      end
    end
  end
end

# CNNX
class Make
  
  # Jn
  def main_start
    @window_console = Window_Console.new
    @window_console.push("qofcN[woCNvO@Version 0.1")
    Graphics.transition(0)
    if Make_RPG::MAKE_DIR_LIST.size == 1
      @mode = nil
      make_dir = Make_RPG::MAKE_DIR_LIST[0]
      update_compile(make_dir)
      Dir.chdir make_dir
      system("start Game.rxproj")
      exit
      return
    else
      @window_console.push("> vWFNgI")
      @window_console.menu(Make_RPG::MAKE_DIR_LIST)
      @mode = "menu"
    end
  end
  
  # I
  def main_end
    Graphics.freeze
    @window_console.dispose
  end
  
  # XV
  def update
    @window_console.update
    if @window_console.output?
      return
    end
    
    case @mode
    when "menu"
      if Input::trigger?(Input::B)
        $scene = nil
      end
      if Input::trigger?(Input::C)
        @mode = nil
        make_dir = @window_console.select_menu
        update_compile(make_dir)
      end
    else
      if Input::trigger?(Input::B)
        $scene = nil
      end
      if Input::trigger?(Input::C)
        $scene = nil
      end
    end
  end
  
  def update_compile(make_dir)
    @window_console.push(" ")
    @window_console.push("> makerpg " + make_dir)
    @window_console.push("make.")
    current_dir = Dir.pwd
    Dir.chdir make_dir
    Event_Compiler.compile_directory("src/events")
    @window_console.push("end.")
    Dir.chdir current_dir
  end
  
  # C
  def main
    main_start
    loop do
      Graphics.update
      Input.update
      update
      if $scene != self
        break
      end
    end
    main_end
  end
end

$scene = Make.new

begin
  Graphics.freeze
  while $scene != nil
    $scene.main
  end
  Graphics.transition(20)
rescue Errno::ENOENT
  filename = $!.message.sub("No such file or directory - ", "")
  print("t@C #{filename} ܂B")
end
