
# NXvbgtH[Ή
$TEST = $DEBUG = ($DEBUG or $TEST)

module Event_Compiler
  
  # Cxg\[XtH_
  SRC_DIR = "src/events"
  
  # Cxg쐬tO
  EVENT_CREATE_FORCE = false
  
  # OW[
  module Log
    LOG_LEVEL = ["off","error","info","debug"]
    @@log_level = 3
    module_function
    def log_level=(name)
      if LOG_LEVEL.include?(name)
        @@log_level = LOG_LEVEL.index(name)
      end
    end
    def debug?
      return @@log_level > 2
    end
    def output(msg)
      p msg
    end
    def error(*args)
      args.each {|msg| output 'ERROR: ' + msg.to_s} if @@log_level > 0
    end
    def info(*args)
      args.each {|msg| output 'INFO: ' + msg.to_s} if @@log_level > 1
    end
    def debug(*args)
      args.each {|msg| output 'DEBUG: ' + msg.to_s} if @@log_level > 2
    end
  end
  
  # [eBeB
  module Event_Compiler_Util
    module_function
    
    # @̃p[X
    BLEND_TYPES = ['ʏ','Z','Z']
    def parse_blend_type(_value)
      value = _value.strip
      id = nil
      if value =~ /^[0-2]$/
        id = value.to_i
      elsif BLEND_TYPES.include? value
        id = BLEND_TYPES.index(value)
      end
      if id.nil?
        # TODO G[
        Log.error("@擾G[F#{value}")
        id = 0
      end
      return id
    end
    
    # ̃p[X
    DIRECTION_TYPES = {''=>2,''=>4,'E'=>6,''=>8}
    def parse_direction(value)
      direction = 2
      if value =~ /^[2468]$/
        direction = value.to_i
      elsif DIRECTION_TYPES.include? value
        direction = DIRECTION_TYPES[value]
      else
        direction = 0
      end
      return direction
    end
    
    def parse_map_type(map,value,default)
      if value =~ /^[0-9]+$/
        return value.to_i
      elsif map.include? value
        return map[value]
      end
      return default
    end
    
    # {^̃p[X
    BUTTON_TYPES = {
      '' => Input::DOWN,
      '' => Input::LEFT,
      'E' => Input::RIGHT,
      '' => Input::UP,
      'DOWN' => Input::DOWN,
      'LEFT' => Input::LEFT,
      'RIGHT' => Input::RIGHT,
      'UP' => Input::UP,
      'A' => Input::A,
      'B' => Input::B,
      'C' => Input::C,
      'X' => Input::X,
      'Y' => Input::Y,
      'Z' => Input::Z,
      'L' => Input::L,
      'R' => Input::R,
      'SHIFT' => Input::SHIFT,
      'CTRL'  => Input::CTRL,
      'ALT'   => Input::ALT,
      'F5' => Input::F5,
      'F6' => Input::F6,
      'F7' => Input::F7,
      'F8' => Input::F8,
      'F9' => Input::F9,
    }
    def parse_button_id(value)
      return parse_map_type(BUTTON_TYPES,value,2)
    end
    
    # XCb`̃p[X
    def parse_switch_id(value)
      id = nil
      if value =~ /\[(.+?)\]/
        id = Switches.index($1.strip)
      end
      if id.nil?
        id = Switches.index(value.strip)
      end
      if id.nil? and value =~ /^[0-9]+$/
        id = value.to_i
      end
      if id.nil?
        # TODO G[
        Log.error("XCb`hc擾G[F#{value}")
      end
      return id
    end
    
    # XCb`l̃p[X
    def parse_switch_value(value)
      if value =~ /ON/
        return 0
      end
      return 1
    end
    
    # ϐ̃p[X
    def parse_variable_id(value)
      id = nil
      if value =~ /^[0-9]+$/
        id = value.to_i
      end
      if value =~ /\[(.+?)\]/
        id = Variables.index($1.strip)
      end
      if id.nil?
        id = Variables.index(value.strip)
      end
      if id.nil?
        # TODO G[
        Log.error("ϐhc擾G[F#{value}")
      end
      return id
    end
    
    # name \bhIuWFNgIDIuWFNgXg猟
    def parse_name_method_object_id(object_name,objects,value,default=1)
      id = nil
      if value =~ /^[0-9]+$/
        id = value.to_i
      else        
        o = objects.find {|_o| (not _o.nil?) and _o.name == value}
        id = o.id unless o.nil?
      end
      if id.nil?
        # TODO G[
        Log.error("#{object_name}擾G[F#{value}")
        id = default
      end
      return id
    end
    
    # RCxg̃p[X
    def parse_common_event_id(value)
      return parse_name_method_object_id("RCxg",Data_Loader.data_common_events,value)
    end
    
    # Gl~[hc̃p[X
    def parse_enemy_id(value)
      actor_id = 1
      if value =~ /Gl~[\[(.+?)\]/
        actor_id = parse_name_method_object_id("Gl~[",Data_Loader.data_enemies,$1)
      elsif value =~ /\[(.+?)\]/
        actor_id = parse_name_method_object_id("Gl~[",Data_Loader.data_enemies,$1)
      else
        actor_id = parse_name_method_object_id("Gl~[",Data_Loader.data_enemies,value)
      end
      return actor_id
    end
    
    # AN^[hc̃p[X
    def parse_actor_id(value)
      actor_id = 1
      if value =~ /AN^[\[(.+?)\]/
        actor_id = parse_name_method_object_id("AN^[",Data_Loader.data_actors,$1)
      elsif value =~ /\[(.+?)\]/
        actor_id = parse_name_method_object_id("AN^[",Data_Loader.data_actors,$1)
      else
        actor_id = parse_name_method_object_id("AN^[",Data_Loader.data_actors,value)
      end
      return actor_id
    end
    
    # XL̃p[X
    def parse_skill_id(value)
      return parse_name_method_object_id("XL",Data_Loader.data_skills,value)
    end
    
    # ACẽp[X
    def parse_item_id(value)
      return parse_name_method_object_id("ACe",Data_Loader.data_items,value)
    end
    
    # 
    def parse_weapon_id(value)
      return parse_name_method_object_id("",Data_Loader.data_weapons,value)
    end
    
    # h
    def parse_armor_id(value)
      return parse_name_method_object_id("h",Data_Loader.data_armors,value)
    end
    
    # Xe[g
    def parse_state_id(value)
      return parse_name_method_object_id("Xe[g",Data_Loader.data_states,value)
    end
    
    # Aj[V
    def parse_animation_id(value)
      return parse_name_method_object_id("Aj[V",Data_Loader.data_animations,value)
    end
    
    # }bv
    def parse_map_id(value)
      id = nil
      if value =~ /^[0-9]+$/
        id = value.to_i
      else
        if value =~ /\[(.+?)\]/
          value = $1
        end
        Data_Loader.data_map_infos.each do |index,info|
          if info.name == value
            id = index
            break
          end
        end
      end
      if id.nil?
        # TODO G[
        Log.error("}bv擾G[F#{value}")
        id = 1
      end
      return id
    end
    
  end
  
  # GgrW^[W[
  module Element_Visitor
    @@visitor_method = Hash.new(:visit_default)
    def visit(element)
      method_name = self.class.visitor_method(element.name)
      if element.related? and (not self.class.visitor_method_exist?(element.name))
        method_name = self.class.visitor_method(element.value)
      end
      if Log.debug?
        Log.debug(method_name.to_s)
      end
      return method(method_name).call(element)
    end
    def visit_default(element)
      return nil
    end
    def visitor_method_exist?(name)
      return @@visitor_method.include?(name)
    end
    def visitor_method(name)
      return @@visitor_method[name]
    end
    def add_visitor_method(name,method_name)
      @@visitor_method[name] = method_name
    end
    def self.included(klass)
      klass.extend Element_Visitor
    end
  end
  
  # Cxgǂݍ݃W[
  module Event_Element_Reader
    
    # Cxgǂݍ
    def self.read_data(lines)
      element = nil
      while (not lines.empty?)
        # s擾
        line = lines.shift
        # ǂݔ΂sH
        if skip_line?(line)
          next
        end
        # ŏ̃Gg쐬
        element = Event_Element.new.parse_element(line)
        # Ggɓǂݍ܂
        element.read_element(lines)
        break
      end
      return element
    end
    
    # ǂݔ΂sH
    def skip_line?(line)
      if line =~ /^#{COMMENT_PREFIX}/
        return true
      end
      if line.strip == ""
        return true
      end
      return false
    end
    module_function :skip_line?
    
    COMMENT_PREFIX       = '#'   # Rgis̕ȂRgj
    EVENT_PREFIX         = ''  # Cxg
    RELATED_EVENT_PREFIX = 'F'  # ֘ACxg
    EVENT_SEPARATOR      = 'F'  # Cxg
    INDENT_STRING        = '@'  # Cfg
    
    # e̒
    EVENT_PREFIX_LEN         = EVENT_PREFIX.length
    RELATED_EVENT_PREFIX_LEN = RELATED_EVENT_PREFIX.length
    EVENT_SEPARATOR_LEN      = EVENT_SEPARATOR.length
    INDENT_STRING_LEN        = INDENT_STRING.length
    
    # Cxg֘ACxg̓T
    def find_start_index(data)
      i1 = data.index(EVENT_PREFIX)
      i2 = data.index(RELATED_EVENT_PREFIX)
      # ǂ
      if i1.nil? and i2.nil?
        # TODO: \G[
        return 0
      end
      # Е̂
      if i1.nil? 
        @related = true
        return i2
      end
      if i2.nil?
        @related = false
        return i1
      end
      # ꍇ
      if i1 < i2
        @related = false
        return i1
      else
        @related = true
        return i2
      end
    end
    
    
    # Ggp[X
    def parse_element(data)
      # f[^
      @data = data
      
      # Cxg֘ACxg̓T
      index_s = find_start_index(@data)
      # Cfg
      @indent = index_s / INDENT_STRING_LEN
      
      # Gg̒o(番܂)
      index_s += EVENT_PREFIX_LEN
      index_e = @data.index(EVENT_SEPARATOR,index_s)
      event_data_name = ""
      if index_e.nil?
        # ꍇ́Af[^Ō܂
        event_data_name = @data[index_s,@data.length]
      else
        event_data_name = @data[index_s,index_e - index_s]
        # Ăꍇ́AGg̒l擾
        @value = @data[index_e + EVENT_SEPARATOR_LEN,@data.length]
      end
      @name = event_data_name.strip
      return self
    end
    
    # Gg쐬
    def create_element(data)
      element = Event_Element.new
      element.parse_element(data) # f[^p[X
      return element
    end
    
    # Ggǂݍ
    def read_element(lines)
      # ȂI
      return self if lines.empty?
      element = nil
      # ɂȂ܂ŌJԂ
      while (not lines.empty?)
        # s擾
        line = lines.shift
        # ǂݔ΂sH
        if skip_line?(line)
          next
        end
        
        # CxgGg쐬
        element = create_element(line)
        
        # 쐬Gg̃Cfg傫
        if element.indent > @indent
          # qGgɒǉ
          @child_elements.push element
          # qGgɓǂݍ܂iŌɍ쐬Ggԋpj
          element = element.read_element(lines)
        end
        # 쐬Gg̃Cfg菬
        if element.indent < @indent
          #@쐬Ggԋp
          return element
        end
        # 쐬Gg֘ACxg
        if element.related?
          # ֘AƂĕۑ
          @related_elements.push element
        else
          # ̃CxgƂĕۑ
          @next_element = element
          # ̃Gg̓ǂݍ݂͏I
          break
        end
      end
      # Ōɍ쐬Ggɑǂݍ܂
      return element.read_element(lines)
    end
    
  end
  
  # CxgGg
  class Event_Element
    include Event_Element_Reader
    
    attr_reader :data   # f[^
    attr_accessor :name   # Gg
    attr_accessor :value  # Ggl
    attr_reader :indent # Cfg
    attr_reader :next_element     # ̃Gg
    attr_reader :related_elements # ֘AGgXg
    attr_reader :child_elements         # qGgXg
    
    def initialize
      @data = ""
      @name = ""
      @value = ""
      @indent = 0
      @next_element = nil
      @related_elements = []
      @child_elements = []
      @related = false # ֘AGgtO
    end
    
    # ֘AGg̏ꍇ true
    def related?
      return @related
    end
    
    # Visitorp^[p Acceptor\bh
    def accept( visitor )
      return visitor.visit(self)
    end
    
    # p[^[ϊ
    def parameters
      return @value.split(/,|A/).collect {|e|e.strip}
    end
    
  end
  
  module_function
  
  # TODO NXvbgtH[Ή\
  
  # }bvf[^[h
  def _load_map_data(map_id)
    filename = sprintf("Data/Map%03d.rxdata", map_id)
    if Log.debug?
      Log.debug("_load_map_data #{filename}")
    end
    map_data = load_data(filename)
    # obNAbv쐬
    if FileTest.directory?("Backup")
      backup_filename = filename.dup
      backup_filename[/^Data/] = "Backup"
      backup_index = 0
      loop do
        backup_index += 1
        unless FileTest.file?(backup_filename + '.' + backup_index.to_s)
          save_data(map_data,backup_filename + '.' + backup_index.to_s)
          if Log.debug?
            Log.debug(backup_filename + '.' + backup_index.to_s)
          end
          break
        end
      end
    else
      Log.error("Backup fBNg܂B")
    end
    return map_data
  end
  
  # }bvf[^Z[u
  def _save_map_data(map_data, map_id)
    filename = sprintf("Data/Map%03d.rxdata", map_id)
    if Log.debug?
      Log.debug("_save_map_data #{filename}")
    end
    return save_data(map_data,filename)
  end
  
  # Cxg\[XRpC
  def compile
    return unless $TEST # eXgsł͖ꍇ́AȂB
    
    # }bvfBNg̊et@CRpC
    compile_directory(SRC_DIR)
  end
  
  # fBNgRpC
  def compile_directory(dir,map_id = 0)
    unless FileTest.directory?(dir)
      Log.error("compile_directory #{dir} fBNg܂B")
      return
    end
    event_files = Dir.glob(dir + '/*.txt')
    unless event_files.empty?
      event_file_mtime = event_files.collect {|filename| File.open(filename).mtime()}.max
      map_data_file_mtime = File.open(sprintf("Data/Map%03d.rxdata", map_id)).mtime()
      if event_file_mtime < map_data_file_mtime
        return
      end
    end
    Log.info("compile_directory #{dir}")
    
    save = false
    map_data = nil
    if map_id != 0
      # }bvf[^ǂݍ
      map_data = _load_map_data(map_id)
    end
    
    # Cxgt@C̃RpCij
    event_files.each do |filename|
      unless map_data.nil?
        compile_file_init(map_data,filename)
      end
    end
    Dir.glob(dir + '/*') do |subdir|
      case File.extname(subdir)
      when "" # fBNg
        filename = File.basename(subdir)
        if filename =~ /^[0-9]+$/
          compile_directory(subdir,filename.to_i)
        end
      when ".txt" # Cxgt@C
        # t@C̃eLXgf[^Cxg
        unless map_data.nil?
          result = compile_file(map_data,subdir)
          save |= result
          if Log.debug?
            Log.debug("compile_file #{result} #{save}")
          end
        end
      end
    end
    
    # }bvf[^
    if save
      _save_map_data(map_data, map_id)
    end
  end
  
  def compile_file_info(filename)
    name = File.basename(filename,".txt")
    # Wt@C擾
    if name =~ /\(([0-9]+)-([0-9]+)\)/
      x = $1.to_i
      y = $2.to_i
      name[/\(([0-9]+)-([0-9]+)\)/] = ""
    end
    # IDƍWt@C擾
    if name =~ /\(([0-9]+)-([0-9]+)-([0-9]+)\)/
      x = $1.to_i
      y = $2.to_i
      event_id = $3.to_i
      name[/\(([0-9]+)-([0-9]+)-([0-9]+)\)/] = ""
    end
    name.strip!
    event_id = 0 if event_id.nil?
    return x,y,name,event_id
  end
  
  # t@CRpC
  def compile_file_init(map_data,filename)
    Log.info("compile_file_init #{filename}")
    
    x,y,name,event_id = compile_file_info(filename)
    unless x.nil? or y.nil?
      # 쐬
      if EVENT_CREATE_FORCE
        # W̃Cxgꍇ́A폜
        map_data.events.select {|_id,_e| _e.x == x and _e.y == y}.each do |id,e|
          map_data.events.delete(e.id)
          if Log.debug?
            Log.debug("delete #{e.name} x=#{e.x} y=#{e.y} event_id = #{e.id}")
          end
        end
        if event_id != 0
          # Wł͂ȂID̃Cxgꍇ́AIDƌ
          id,e = map_data.events.find {|_id,_e| _e.id == event_id and not (_e.x == x and _e.y == y)}
          if not e.nil?
            id_list = map_data.events.keys
            for i in 1 .. 999
              unless id_list.include? i
                e.id = i
                map_data.events[i] = e
                break
              end
            end
          end
        end
      else
        # W̃Cxgꍇ́A쐬Ȃ
        if map_data.events.any? {|_id,_e| _e.x == x and _e.y == y}
          return false
        end
        if event_id != 0
          # ID̃Cxgꍇ́A쐬Ȃ
          if map_data.events.any? {|_id,_e| _e.id == event_id}
            return false
          end
        end
      end
      # CxgID܂ĂȂꍇ
      if event_id == 0
        if map_data.events.empty?
          event_id = 1
        else
          id_list = map_data.events.keys
          for i in 1 .. 999
            unless id_list.include? i
              event_id = i
              break
            end
          end
        end
      end
      if Log.debug?
        Log.debug("#{name} x=#{x} y=#{y} event_id = #{event_id}")
      end
      event = RPG::Event.new(x,y)
      # CxgID
      event.id = event_id
      # Cxg      
      event.name = File.basename(name)
      # VKɍ쐬Cxg̓y[W
      event.pages = []
      # }bvɃCxgǉ
      map_data.events[event.id] = event
      return true
    end
    return false
  end
  
  # t@CRpC
  def compile_file(map_data,filename)
    Log.info("compile_file #{filename}")
    
    # CxgƍWt@C擾
    x,y,name,event_id = compile_file_info(filename)
    unless x.nil? or y.nil?
      
      if Log.debug?
        Log.debug("#{name} x=#{x} y=#{y}")
      end
      # W̃Cxg
      id,e = map_data.events.find {|_id,_e| _e.x == x and _e.y == y}
      if e.nil?
        Log.error("Cxg܂B#{name} x=#{x} y=#{y}")
        return false
      end
      if event_id == 0
        # 쐬
        if EVENT_CREATE_FORCE
          event_id = e.id
        else
          unless e.pages.empty?
            return false
          end
          event_id = e.id
        end
      end
      # CxgID
      if event_id == 0
        Log.error("CxghcsB#{name} x=#{x} y=#{y}")
        return false
      end
      if Log.debug?
        Log.debug("event_id = #{event_id}")
      end
      event = RPG::Event.new(x,y)
      # CxgID
      event.id = event_id
      # Cxg      
      event.name = File.basename(name)
      # CxgRpC
      compile_event(map_data,event,filename)
      # }bvɃCxgǉ
      map_data.events[event.id] = event
      return true
    end
    return false
  end
  
  # t@C̃[h
  def load_compile_event_file(filename)
    path = File.dirname(filename)
    lines = []
    IO.foreach(filename) do |line|
      line = Win32::String_Converter.sjis_to_utf8(line)
      line.strip!
      if line =~ /include\((.+?)\)/
        lines.concat(load_compile_event_file(path + '/' + $1.strip))
      end
      lines.push line
    end
    return lines
  end
  
  # CxgRpC
  def compile_event(map_data,event,filename)
    # ؂蕶 l
    boundary = "---"
    
    # y[Wя
    pages = []
    
    page_data = {}
    data = []
    page_data['default'] = data
    
    # ǂݍ
    lines = load_compile_event_file(filename)
    lines.each do |line|
     (key,value) = line.split(/\s*=\s*/)
      if key == "boundary" # ؂蕶
        boundary = value
        next
      elsif key == "pages" # y[W
        pages = value.split(/\s*,\s*/)
        next
      elsif key == "page.name" # y[W
        page_data[value] = data
        next
      elsif boundary == line
        data = []
        next
      end
      data.push line
    end
    
    event.pages = []
    
    # ftHgy[Wev[g
    default_page = RPG::Event::Page.new
    # ftHgy[Wev[g쐬
    set_header(default_page,page_data['default'])
    
    # ey[Wяɍ쐬
    pages.each do |name|
      # ftHgy[WfB[vRs[
      page = Marshal.load(Marshal.dump(default_page))
      # y[W쐬
      compile_page(map_data,event,page,page_data[name])
      # CxgɃy[Wǉ
      event.pages.push(page)
      # 擪ɒ߂̒ǉ
      page.list.unshift RPG::EventCommand.new(108, 0, ["#{name}"])
    end
    
  end
  
  # y[WɃRpC
  def compile_page(map_data,event,page,data)
    set_header(page,data)
    # TODO CxgXg쐬
    data.delete_if {|l| l == ""}
    element = Event_Element_Reader.read_data(data)
    page.list = element.accept(Event_Element_Visitor.new(map_data,event,page))
  end
  
  # wb_[ݒ
  def set_header(page,data)
    while (not data.empty?)
      line = data.shift
      break if line == "" # 󔒍s܂łwb_[
       (key,value) = line.split(/\s*=\s*/,2)
      if key =~ /^condition\.(.+)$/
        set_condition(page.condition,$1,value)
      elsif key =~ /^graphic\.(.+)$/
        set_graphic(page.graphic,$1,value)
      else
        set_property(page,key,value)
      end
    end
  end
  
  STRING_PARAMETERS = {
    'trigger' => {
      '{^'        => 0,
      'vC[ڐG' => 1,
      'CxgڐG'   => 2,
      's'          => 3,
      '񏈗'          => 4,
    },
  }
  
  # vpeB𓮓Iɐݒ
  def set_property(obj,key,value)
    # getter 邩H
    if obj.class.method_defined?(key)
      # ۂ get Ă݂
      case obj.method(key).call
      when Numeric # l̏ꍇ
        if value =~ /^[0-9]+$/
          # lɂ setter Ă
          obj.method(key + '=').call(value.to_i)
        else
          # lɑ΂ĕ񂪐ݒ肳Ăꍇ
          if STRING_PARAMETERS.include?(key)
            if STRING_PARAMETERS[key].include?(value)
              obj.method(key + '=').call(STRING_PARAMETERS[key][value])
            end
          end
        end
      when String # ̏ꍇ
        # ɂ setter Ă
        obj.method(key + '=').call(value.to_s)
      when TrueClass
        # ɂ setter Ă
        obj.method(key + '=').call(value == "true")
      when FalseClass
        # ɂ setter Ă
        obj.method(key + '=').call(value == "true")
      end
    end
  end
  
  # OtBbNݒ
  def set_graphic(condition,key,value)
    set_property(condition,key,value)
  end
  
  # ݒ
  def set_condition(condition,key,value)
    case key
    when "switch1"
      if Switches.exist?(value)
        condition.switch1_valid = true
        condition.switch1_id = Switches.index(value)
        return
      else
        Log.error "XCb`u#{value}v́A܂"
        return
      end
    when "switch2"
      if Switches.exist?(value)
        condition.switch2_valid = true
        condition.switch2_id = Switches.index(value)
        return
      else
        Log.error "XCb`u#{value}v́A܂"
        return
      end
    when "variable"
      if Variables.exist?(value)
        condition.variable_valid = true
        condition.variable_id = Variables.index(value)
        return
      else
        Log.error "ϐu#{value}v́A܂"
        return
      end
    when "self_switch"
      if ['A','B','C','D'].include? value
        condition.self_switch_valid = true
        condition.self_switch_ch = value
        return
      else
        Log.error "ZtXCb`u#{value}v́A܂"
        return
      end
    else
      set_property(condition,key,value)
    end
  end
  
end
