require 'rgss-lib/common/DijkstraAlgorithm.rb'

module Am
  # _CX
  module Dice
    def self.[](n)
      rand(n) + 1
    end
  end
  
  # }bvf[^
  class MapData
    attr_reader :x
    attr_reader :y
    attr_reader :width
    attr_reader :height
    
    # 
    def initialize(x,y,w,h)
      @x = x
      @y = y
      @width = w
      @height = h
      @data = []
      create(@width,@height)
    end
    
    # 쐬
    def create(w,h)
      for y in 0 ... h
        @data[y] = [0] * w
      end
    end
    
    # f[^ݒ
    def []=(x,y,n)
      @data[y][x] = n
    end
    
    # f[^擾
    def [](x,y) @data[y][x] end
    
    def left;   @x           end
    def right;  @x + @width  end
    def top;    @y           end
    def bottom; @y + @height end
    def center_x; @x + @width / 2 end
    def center_y; @y + @height / 2 end
    
    def collision?(other)
      if self == other
        return false
      end
      # oEeBO{bNXH
      return (not (self.right < other.left or other.right < self.left or self.bottom < other.top or other.bottom < self.top))
    end
    
    # MapData}[W
    def merge(map_data)
      for x in map_data.left ... map_data.right
        for y in map_data.top ... map_data.bottom
          next if map_data[x - map_data.x,y - map_data.y] == 0
          self[x,y] = map_data[x - map_data.x,y - map_data.y] 
        end
      end
    end
    
    # _v
    def dump
      format = "%2d"
      result = "   "
      @width.times do |x|
        result += sprintf(format,x + 1)
      end
      result += "\n"
      result += "   "
      @width.times do |x|
        result += "--"
      end
      result += "\n"
      @height.times do |y|
        result += sprintf(format +"|",y + 1)
        @width.times do |x|
          if self[x,y] == 0
            result += "  "
          else
            result += sprintf(format,self[x,y])
          end
        end
        result += "\n"
      end
      puts result
    end
  end
  
  # f[^
  class RoomData < MapData
    attr_writer :x
    attr_writer :y
    
    # 
    def initialize(w,h)
      super(0,0,w,h)
      @fix_position = false
    end
    def fix_position?() @fix_position end
    def x=(x)
      return @x if fix_position?
      @x = x
    end
    def y=(y)
      return @y if fix_position?
      @y = y
    end
    def collision?(room)
      if self.fix_position? and room.fix_position?
        return false
      end
      super
    end
    def distance(room)
      x1 = self.center_x
      y1 = self.center_y
      x2 = room.center_x
      y2 = room.center_y
      return Math.sqrt(((x1 - x2) ** 2 + (y1 - y2) ** 2))
    end
    def joint_x(room)
      x1 = self.center_x
      y1 = self.center_y
      x2 = room.center_x
      y2 = room.center_y
      dw = (x1 - x2).abs
      dh = (y1 - y2).abs
      if dw < dh
        # ̕߂
        if y1 < y2
          # ɐڑ
          return self.center_x
        else
          # ɐڑ
          return self.center_x
        end
      else
        # c̕߂
        if x1 < x2
          # Eɐڑ
          return self.right - 1
        else
          # ɐڑ
          return self.left
        end
      end
    end
    def joint_y(room)
      x1 = self.center_x
      y1 = self.center_y
      x2 = room.center_x
      y2 = room.center_y
      dw = (x1 - x2).abs
      dh = (y1 - y2).abs
      if dw < dh
        # ̕߂
        if y1 < y2
          # ɐڑ
          return self.bottom - 1
        else
          # ɐڑ
          return self.top
        end
      else
        # c̕߂
        if x1 < x2
          # Eɐڑ
          return self.center_y
        else
          # ɐڑ
          return self.center_y
        end
      end
    end
  end
  
  # lp
  class RoomSquare < RoomData
    # 
    def initialize()
      super(Dice[6]+4,Dice[6]+4)
    end
    def create(w,h)
      super(w,h)
      h.times {|y| w.times {|x| self[x,y] = 1}}
    end
  end
  
  # ۂ
  class RoomCircle<  RoomData
    # 
    def initialize()
      n = Dice[6]+4
      if n % 2 == 0
        n += 1
      end
      @r = n / 2
      super(n,n)
    end
    def create(w,h)
      super(w,h)
      cx = w / 2
      cy = h / 2
      h.times do |y|
        w.times do |x|
          if Math.sqrt(((cx - x) ** 2 + (cy - y) ** 2)) <= @r
            self[x,y] = 1
          else
            self[x,y] = 0
          end
        end
      end
    end
  end
  
  class RouteData < MapData
    attr_writer :x
    attr_writer :y
    attr_reader :room1
    attr_reader :room2
    # 
    def initialize(room1,room2)
      @room1 = room1
      @room2 = room2
      @rooms = [@room1,@room2]
      x = @rooms.collect {|r| r.x}.min
      y = @rooms.collect {|r| r.y}.min
      w = @rooms.collect {|r| r.right}.max - x
      h = @rooms.collect {|r| r.bottom}.max - y
      super(x,y,w,h)
    end
  end
  
  class RouteDefault < RouteData
    # 
    def initialize(room1,room2)
      super(room1,room2)
    end
    def create(w,h)
      super(w,h)
      sx = self.room1.center_x
      sy = self.room1.center_y
      ex = self.room2.center_x
      ey = self.room2.center_y
      if (ex - sx).abs < (ey - sy).abs
        while sx != ex
          sx += sx < ex ? +1 : -1
          self[sx -self.x,sy -self.y] = 1
        end
        while sy != ey
          sy += sy < ey ? +1 : -1
          self[sx -self.x,sy -self.y] = 1
        end
      else
        while sy != ey
          sy += sy < ey ? +1 : -1
          self[sx -self.x,sy -self.y] = 1
        end
        while sx != ex
          sx += sx < ex ? +1 : -1
          self[sx -self.x,sy -self.y] = 1
        end
      end
    end
  end
  
  class RouteManhattan < RouteData
    # 
    def initialize(room1,room2)
      super(room1,room2)
    end
    def create(w,h)
      super(w,h)
      sx = self.room1.joint_x(self.room2)
      sy = self.room1.joint_y(self.room2)
      ex = self.room2.joint_x(self.room1)
      ey = self.room2.joint_y(self.room1)
      w = (sx - ex).abs
      h = (sy - ey).abs
      cw = (self.room1.center_x - self.room2.center_x).abs
      ch = (self.room1.center_y - self.room2.center_y).abs
      cx = w / 2
      cxm = w % 2
      cy = h / 2
      cym = h % 2
      if sx < ex
        ax = +1
      else
        ax = -1
      end
      if sy < ey
        ay = +1
      else
        ay = -1
      end
      if cw < ch
        # c̕
        for i in 0 ... cy
          self[sx - self.x,sy - self.y] = 1
          sy += ay
        end
        for i in 0 ... w
          self[sx - self.x,sy - self.y] = 1
          sx += ax
        end
        for i in 0 .. (cy + cym)
          self[sx - self.x,sy - self.y] = 1
          sy += ay
        end
      else
        # ̕
        for i in 0 ... cx
          self[sx - self.x,sy - self.y] = 1
          sx += ax
        end
        for i in 0 ... h
          self[sx - self.x,sy - self.y] = 1
          sy += ay
        end
        for i in 0 .. (cx + cxm)
          self[sx - self.x,sy - self.y] = 1
          sx += ax
        end
      end
    end
  end
  
  # }bv쐬NX
  class MapCreater
    # ̈ʒu
    @@adjust_room_procs = {}
    def self.add_adjust_room_proc(adjust_type,adjust)
      case adjust
      when Adjust_Room_Proc
        @@adjust_room_procs[adjust_type] = adjust.method(:adjust_room_proc)
      when Proc,Method
        @@adjust_room_procs[adjust_type] = adjust
      end
    end
    
    # 
    def initialize
      @rooms = []
      @routes = []
      @adjust_room_type = 0
    end
    def room_each(&block) @rooms.each(&block) end
    def route_each(&block) @routes.each(&block) end
    def width() @rooms.collect {|room| room.right}.max end
    def height() @rooms.collect {|room| room.bottom}.max end
    
    # ̍쐬
    # n :: ̐i΃_ 3d6j
    def create_rooms(n=0)
      if n == 0
        n = Dice[6] + Dice[6] + Dice[6]
      end
      n.times do |i|
        @rooms.push RoomCircle.new
        #        @rooms.push RoomSquare.new
      end
      @@adjust_room_procs[@adjust_room_type].call(@rooms)
      x = @rooms.collect {|room| room.x}.min
      y = @rooms.collect {|room| room.y}.min
      @rooms.collect {|room| room.x -= x}
      @rooms.collect {|room| room.y -= y}
    end
    
    def route_search(rooms_size,routes)
      da = DijkstraAlgorithm.new((0 .. rooms_size).to_a)
      da.setupMatrix() do |i1,i2|
        if routes.any? {|r| (r[0] == i1 and r[1] == i2) or (r[0] == i2 and r[1] == i1)}
          next 1
        end
        next DijkstraAlgorithm::MAX_DISTANCE
      end
      not_routes = []
      rooms_size.times do |i1|
        rooms_size.times do |i2|
          next if i1 <= i2
          if da.search(i1,i2).empty?
            not_routes.push [i1,i2]
          end
        end
      end
      return not_routes
    end
    
    def create_route()
      return if @rooms.empty?
      #      rooms = @rooms.dup
      #      
      #      rooms.each do |room1|
      #        min = 1000
      #        room2 = nil
      #        rooms.each do |room3|
      #          next if room1 == room3
      #          if room1.distance(room3).to_i < min
      #            room2 = room3
      #          end
      #        end
      #        @routes.push RouteDefault.new(room1,room2)
      #      end
      route_check = []
      @rooms.size.times do |i1|
        @rooms.size.times do |i2|
          if i1 < i2
            route_check.push [i1,i2]
          end
        end
      end
      route_check.sort! {|a,b| @rooms[a[0]].distance(@rooms[a[1]]) <=> @rooms[b[0]].distance(@rooms[b[1]])}
      routes = []
      room_check = []
      
      route_check.each do |route|
        if room_check.include? route[0] and room_check.include? route[1]
          next
        end
        room_check.push(*route)
        routes.push route
      end
      loop do
        not_routes = route_search(@rooms.size,routes)
        if not_routes.empty?
          break
        end
        not_routes.sort! {|a,b| @rooms[a[0]].distance(@rooms[a[1]]) <=> @rooms[b[0]].distance(@rooms[b[1]])}
        routes.push not_routes[0]
      end
      #            @rooms.size.times do |i|
      #              route = route_check.find {|r| r[0] == i or r[1] == i}
      #              route_check.delete(route)
      #              routes.push route
      #            end
      
      #      routes = route_check.select do |i|
      #        if room_check.include?(i[0]) and room_check.include?(i[1])
      #          next false
      #        end
      #        room_check.push i[0]
      #        room_check.push i[1]
      #        next true
      #      end
      routes.each do |i|
        #        @routes.push RouteDefault.new(@rooms[i[0]],@rooms[i[1]])
        @routes.push RouteManhattan.new(@rooms[i[0]],@rooms[i[1]])
      end
    end
    
  end
  
  #---------------------------------
  # zuNX
  #---------------------------------
  module Adjust_Room_Proc
    def adjust_room_proc(rooms)
      raise Exception.new('unsupported')
    end
  end
  
  class MapCreater_Default
    include Adjust_Room_Proc
    def initialize
    end
    def space_length
      return Dice[6]
    end
    def adjust_away_room(room1,room2)
      ax = (room1.center_x - room2.center_x).abs
      ay = (room1.center_y - room2.center_y).abs
      if ax > ay
        if room1.center_x < room2.center_x
          room1.x -= self.space_length
          room2.x += self.space_length
        else
          room1.x += self.space_length
          room2.x -= self.space_length
        end
      else
        if room1.center_y < room2.center_y
          room1.y -= self.space_length
          room2.y += self.space_length
        else
          room1.y += self.space_length
          room2.y -= self.space_length
        end
      end
    end
    def adjust_room_proc(rooms)
      while rooms.any? {|r1| rooms.any? {|r2| r1.collision?(r2)}}
        rooms.each do |room1|
          rooms.each do |room2|
            if room1.collision?(room2)
              adjust_away_room(room1,room2)
            end
          end
        end
      end
    end
  end
  MapCreater.add_adjust_room_proc(0, MapCreater_Default.new)
  
  def self.test
    map_creater = MapCreater.new
    map_creater.create_rooms()
    map_creater.create_route()
    m = MapData.new(0,0,map_creater.width,map_creater.height)
    map_creater.room_each {|room| m.merge(room)}
    map_creater.route_each {|route| m.merge(route)}
    m.dump
  end
  
end

Am.test
