# ACeWFl[^[
# ACe(Game_Item Game_Weapon Game_Armor)̒`艺ɐݒu
# Author:: fukuyama
# Date:: 2008/12/12
# Copyright:: Copyright (c) 2008 rgss-lib

# RPG::Item_Attribute  RPG::Item_Expansion ǂݍ
Data_Loader.data_item_attr
Data_Loader.data_item_exp

# ACeWFl[^[NX
class Game_Item_Generator
  # 
  def initialize
  end

  # ACe쐬
  # id:: 쐬ACeID
  # exp_list:: tgf[^ID̃Xgizj
  def create_item(id,exp_list=[])
    item = Game_Item.new(id)
    return set_expansions(item,exp_list)
  end

  # 쐬
  # id:: 쐬镐ID
  # exp_list:: tgf[^ID̃Xgizj
  def create_weapon(id,exp_list=[])
    item = Game_Weapon.new(id)
    return set_expansions(item,exp_list)
  end

  # h쐬
  # id:: 쐬hID
  # exp_list:: tgf[^ID̃Xgizj
  def create_armor(id,exp_list=[])
    item = Game_Armor.new(id)
    return set_expansions(item,exp_list)
  end

  # gf[^ݒ
  # item:: ݒΏۃACe
  # expansions:: ݒ肷Game_Item_Expansion ̖OXg
  def set_expansions(item,exp_list=[])
    expansions = create_item_expansions(exp_list)
    item.set_expansions(expansions)
    return item
  end

  # gf[^ǉ
  # item:: ǉΏۃACe
  # expansions:: ǉGame_Item_Expansion ̖OXg
  def add_expansions(item,exp_list=[])
    expansions = create_item_expansions(exp_list)
    item.add_expansions(expansions)
    return item
  end

  # gf[^CX^X쐬
  # exp_list:: gf[^ID̃Xgizj
  def create_item_expansions(exp_list)
    data_item_exp = Data_Loader.data_item_exp
    return exp_list.collect { |id| Game_Item_Expansion.new(data_item_exp[id],self) }
  end

  # gf[^CX^X쐬
  # Game_Item_Expansion@CX^XɎgp
  # exp_list:: gf[^ID̃Xg
  def create_item_attributes(attr_list)
    data_item_attr = Data_Loader.data_item_attr
    return attr_list.collect { |id|
      Game_Item_Attribute.new(data_item_attr[id],self) }
  end

end

# ACegW[
module Game_Item_Expansion_Module

  # gf[^܂߂ڍׂȃACe
  attr_accessor :name_detail
  def initialize(*args)
    super(*args)
    @expansions = []
  end

  # gf[^ݒ
  # expansions:: ݒ肷Game_Item_Expansion ̃Xg
  def set_expansions(expansions=[])
    @expansions = expansions.dup
    apply_expansions()
  end

  # gf[^ǉ
  # expansions:: ǉGame_Item_Expansion ̃Xg
  def add_expansions(expansions=[])
    @expansions.concat(expansions)
    apply_expansions()
  end

  def setup(item)
    super(item)
    # ڍׂ̖O
    @name_detail = @name
    if not @expansions.empty?
      # ʏ\閼O̐ݒ
      @name += "+#{@expansions.size}"
    end
  end
  
  # ʏgOύX
  def name
    if defined? USE_ITEM_NAME_DETAIL and USE_ITEM_NAME_DETAIL
      return @name_detail.nil? ? @name : @name_detail
    end
    return @name
  end
  # wvŎgOǉ
  def description
    if (not defined? USE_ITEM_NAME_DETAIL) or (not USE_ITEM_NAME_DETAIL)
      return @name_detail.nil? ? @description : @name_detail + "\n" + @description
    end
    return @description
  end

  # gf[^̔fB
  # gf[^ACeɒǉB
  def apply_expansions()
    setup(@data_base)
    @expansions.each do |e|
      e.apply(self)
    end
  end
  private :apply_expansions

end

# NXɃACegW[CN[h
class Game_Weapon
  include Game_Item_Expansion_Module
end

# hNXɃACegW[CN[h
class Game_Armor
  include Game_Item_Expansion_Module
end

# ACeNXɃACegW[CN[h
class Game_Item
  include Game_Item_Expansion_Module
end
