# Train_Actor::Game_Player_Module
# Game_PlayerpsW[
# Author:: fukuyama
# Date:: 2007/12/31
# Copyright:: Copyright (C) 2005-2007 rgss-lib

module Train_Actor

  module Game_Player_Module
    attr_reader :move_speed
    attr_reader :step_anime
    attr_reader :direction_fix

    def update_party_actors
      if $game_party.actors.empty?
        return
      end
      $game_party.update_party_actors
      actor = $game_party.actors[0]
      if not actor.dead?
        if not @prev_dead.nil?
          @character_name = actor.character_name
          @character_hue = actor.character_hue
          @prev_dead = nil
        end
        return
      end
      @prev_dead = true
      $game_party.actors.each do |actor|
        if not actor.dead?
          @character_name = actor.character_name
          @character_hue = actor.character_hue
          break
        end
      end
    end
    def update
      update_party_actors
      super
    end
    def moveto( x, y )
      $game_party.moveto_party_actors( x, y )
      super( x, y )
    end
    def move_down(turn_enabled = true)
      if passable?(@x, @y, Input::DOWN)
        $game_party.move_down_party_actors(turn_enabled)
      end
      super(turn_enabled)
    end
    def move_left(turn_enabled = true)
      if passable?(@x, @y, Input::LEFT)
        $game_party.move_left_party_actors(turn_enabled)
      end
      super(turn_enabled)
    end
    def move_right(turn_enabled = true)
      if passable?(@x, @y, Input::RIGHT)
        $game_party.move_right_party_actors(turn_enabled)
      end
      super(turn_enabled)
    end
    def move_up(turn_enabled = true)
      if passable?(@x, @y, Input::UP)
        $game_party.move_up_party_actors(turn_enabled)
      end
      super(turn_enabled)
    end
    def move_lower_left
      # A ̂ǂ炩̃R[Xʍs\ȏꍇ
      if (passable?(@x, @y, Input::DOWN) and passable?(@x, @y + 1, Input::LEFT)) or
       (passable?(@x, @y, Input::LEFT) and passable?(@x - 1, @y, Input::DOWN))
        $game_party.move_lower_left_party_actors
      end
      super
    end
    def move_lower_right
      # EAE ̂ǂ炩̃R[Xʍs\ȏꍇ
      if (passable?(@x, @y, Input::DOWN) and passable?(@x, @y + 1, Input::RIGHT)) or
       (passable?(@x, @y, Input::RIGHT) and passable?(@x + 1, @y, Input::DOWN))
        $game_party.move_lower_right_party_actors
      end
      super
    end
    def move_upper_left
      # とA ̂ǂ炩̃R[Xʍs\ȏꍇ
      if (passable?(@x, @y, Input::UP) and passable?(@x, @y - 1, Input::LEFT)) or
       (passable?(@x, @y, Input::LEFT) and passable?(@x - 1, @y, Input::UP))
        $game_party.move_upper_left_party_actors
      end
      super
    end
    def move_upper_right
      # とEAE ̂ǂ炩̃R[Xʍs\ȏꍇ
      if (passable?(@x, @y, Input::UP) and passable?(@x, @y - 1, Input::RIGHT)) or
       (passable?(@x, @y, Input::RIGHT) and passable?(@x + 1, @y, Input::UP))
        $game_party.move_upper_right_party_actors
      end
      super
    end
    def jump(x_plus, y_plus)
      # VWvZ
      new_x = @x + x_plus
      new_y = @y + y_plus
      # Zl (0,0) ̏ꍇAWv悪ʍs\ȏꍇ
      if (x_plus == 0 and y_plus == 0) or passable?(new_x, new_y, 0)
        $game_party.jump_party_actors(x_plus, y_plus)
      end
      super(x_plus, y_plus)
    end
  end

end

class Game_Player
  include Train_Actor::Game_Player_Module
end
