# ACe𔃂̃AN^[Xe[^XEBhE(Window_Shop_Actor_Status)
# Author:: fukuyama
# Date:: 2007/10/13
# Copyright (C) 2005-2010 rgss-lib

module DQ
  class Window_Shop_Actor_Status < Window_Base
    #----------------------------------------------------------------------------
    # 
    #----------------------------------------------------------------------------
    def initialize(parent)
      @actors = $game_party.actors
      @item_height = ITEM_HEIGHT

      # RecWvZ
      w = WINDOW_SHOP_STATUS_WIDTH + 32
      h = (@actors.size + 2) * @item_height + 32
      x = parent.left
      y = parent.bottom
      super(x,y,w,h)
      self.contents = Bitmap.new(self.width - 32, self.height - 32)
      @item = nil

      # \WvZ
      w = self.contents.width
      @iw = self.contents.text_size('0').width * 4
      @cw = self.contents.text_size('').width
      @bx = w - @iw - 2
      @cx = @bx - @cw
      @ax = @cx - @iw - 2
    end

    #----------------------------------------------------------------------------
    # ACeݒ
    #----------------------------------------------------------------------------
    def set_item(item)
      if @item != item
        @item = item
        refresh
      end
    end

    #----------------------------------------------------------------------------
    # ĕ`
    #----------------------------------------------------------------------------
    def refresh
      self.contents.clear
      self.contents.font.color = normal_color
      if Item_Facade.item?(@item)
        refresh_item
        refresh_backpack(Game_Item)
      elsif Item_Facade.weapon?(@item)
        refresh_weapon
        refresh_backpack(Game_Weapon)
      elsif Item_Facade.armor?(@item)
        refresh_armor
        refresh_backpack(Game_Armor)
      end
    end

    #----------------------------------------------------------------------------
    # ^Cg
    #----------------------------------------------------------------------------
    def draw_title(title)
      w = self.contents.width
      h = @item_height
      x,y = 0,0
      self.contents.draw_text(x,y,w,h,title,1)
      y += h
    end

    #----------------------------------------------------------------------------
    # Xe[^X
    #----------------------------------------------------------------------------
    def draw_equip_status(index,a,b)
      y = index * @item_height + @item_height
      self.contents.draw_text(@ax, y, @iw, @item_height, a.to_s, 2)
      self.contents.draw_text(@cx, y, @cw, @item_height, '',   0)
      self.contents.draw_text(@bx, y, @iw, @item_height, b.to_s, 2)
    end

    #----------------------------------------------------------------------------
    # s
    #----------------------------------------------------------------------------
    def draw_no_equip_status(index)
      y = index * @item_height + @item_height
      self.contents.draw_text(0,y,self.contents.width,@item_height,'тłȂ',2)
    end

    #----------------------------------------------------------------------------
    # AN^[
    #----------------------------------------------------------------------------
    def draw_actor_name(index,actor)
      y = index * @item_height + @item_height
      self.contents.draw_text(0,y,self.contents.width,@item_height,actor.name,0)
    end

    #----------------------------------------------------------------------------
    # Xe[^X
    #----------------------------------------------------------------------------
    def draw_item_status(index,text)
      y = index * @item_height + @item_height
      self.contents.draw_text(0,y,self.contents.width,@item_height,text,2)
    end

    #----------------------------------------------------------------------------
    # 
    #----------------------------------------------------------------------------
    def draw_item_count(index,actor,klass)
      y = index * @item_height + @item_height
      count = actor.backpack.item_count_id(@item.id,klass)
      if count != 0
        text  = "#{count} "
        self.contents.draw_text(0,y,self.contents.width,@item_height,text,1)
      end
    end

    #----------------------------------------------------------------------------
    # ̕\
    #----------------------------------------------------------------------------
    def refresh_item
      # ^Cg
      draw_title('ǂ')

      @actors.each_index do |index|
        actor = @actors[index]

        # AN^[
        draw_actor_name(index,actor)

        count = actor.backpack.item_count_id(@item.id,Game_Item)
        if 0 < count
          draw_item_status(index,'Ă')
        else
          draw_item_status(index,'ĂȂ')
        end
        draw_item_count(index,actor,Game_Item)
      end
    end

    #----------------------------------------------------------------------------
    # ̕\
    #----------------------------------------------------------------------------
    def refresh_weapon
      # ^Cg
      draw_title($data_system.words.atk)
      @actors.each_index do |index|
        actor = @actors[index]

        # AN^[
        draw_actor_name(index,actor)

        if Item_Facade.equippable?(@item,actor)
          # łꍇ
          (a,b) = Item_Facade.equip_ability_calc(@item,actor)
          draw_equip_status(index,a,b)
        else
          # łȂꍇ
          draw_no_equip_status(index)
        end
        draw_item_count(index,actor,Game_Weapon)
      end
    end

    #----------------------------------------------------------------------------
    # h̕\
    #----------------------------------------------------------------------------
    def refresh_armor
      # ^Cg
      draw_title($data_system.words.pdef)

      @actors.each_index do |index|
        actor = @actors[index]

        # AN^[
        draw_actor_name(index,actor)

        if Item_Facade.equippable?(@item,actor)
          # łꍇ
          (a,b) = Item_Facade.equip_ability_calc(@item,actor)
          draw_equip_status(index,a,b)
        else
          # łȂꍇ
          draw_no_equip_status(index)
        end
        draw_item_count(index,actor,Game_Armor)
      end
    end

    #----------------------------------------------------------------------------
    # ӂ̕\
    #----------------------------------------------------------------------------
    def refresh_backpack(klass)
      index = (@actors.size)
      y = index * @item_height + @item_height
      self.contents.draw_text(0,y,self.contents.width,@item_height,'ӂ̂Ȃ',0)
      count = $game_party.backpack.item_count_id(@item.id,klass)
      if 0 < count
        draw_item_status(index,'͂Ă')
      else
        draw_item_status(index,'͂ĂȂ')
      end
      draw_item_count(index,$game_party,klass)
    end
  end

end
