#==============================================================================
#  Window_Message_InputNumber
#------------------------------------------------------------------------------
# bZ[W\ɐl͂sEBhEłB
#==============================================================================

class Window_Message_InputNumber < Window_InputNumber
  DIGITS_MIN_VARIABLE_NAME = 'l͍ŏ'
  CANCEL_VARIABLE_NAME = 'l̓LZl'
  USE_CANCEL_SWITCH_NAME = 'l̓LZ'
  INIT_CURSOR_INDEX_VARIABLE_NAME = 'l̓J[\ʒu'

  attr_reader :cancel_number

  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize(digits_max)
    super(digits_max)

    # ͎̍ŏB艺͕̌ύXłȂB
    @digits_min = Script_Config.variable(DIGITS_MIN_VARIABLE_NAME,0) - 1
    Variables[DIGITS_MIN_VARIABLE_NAME] = 0

    # LZ̒l
    @cancel_number = Script_Config.variable(CANCEL_VARIABLE_NAME,0)
    Variables[CANCEL_VARIABLE_NAME] = 0

    # LZ
    @cancel_enable = Script_Config.switch(USE_CANCEL_SWITCH_NAME,false)
    Switches[USE_CANCEL_SWITCH_NAME] = false

    # J[\ʒu
    @index = digits_max - Script_Config.variable(INIT_CURSOR_INDEX_VARIABLE_NAME,0)
    Variables[INIT_CURSOR_INDEX_VARIABLE_NAME] = 0

    @digits_min = 0 if @digits_min < 0
    @digits_min = @digits_max - 1 if @digits_min >= @digits_max
    tmp_max = (@digits_max - @digits_min)
    @index = (@index + tmp_max) % tmp_max
  end

  # LZ\H
  def cancel_enable?
    return @cancel_enable
  end

  #--------------------------------------------------------------------------
  #  t[XV
  #--------------------------------------------------------------------------
  def update
    # J[\̈ړ͈͂ŏŐB
    if @digits_max > 1 and @digits_min > 0
      # J[\E
      if Input.repeat?(Input::RIGHT)
        $game_system.se_play($data_system.cursor_se)
        tmp_max = (@digits_max - @digits_min)
        @index = (@index + 1) % tmp_max
        update_cursor_rect
        return
      end
      # J[\
      if Input.repeat?(Input::LEFT)
        $game_system.se_play($data_system.cursor_se)
        tmp_max = (@digits_max - @digits_min)
        @index = (@index + tmp_max - 1) % tmp_max
        update_cursor_rect
        return
      end
    end
    super
  end

end
