# Markup_Text_Position@}[NAbveLXg|WV
#
# \bottom
# \left[dummy]
# \right[dummy]
# \center[dummy]
# \center_left[dummy]
# \center_right[dummy]
# \current_line[s]
#
# Author:: fukuyama
# Date:: 2007/08/25
# Copyright:: Copyright (c) 2005,2006,2007 fukuyama

module Markup_Text_Position
  module Markup_Current_Line
    module_function
    def query
      return /^\\current_line\[([0-9]+)\]/
    end

    def transfer(bmp, x, y, text, match)
      index = match[1].to_i
      y = Markup_New_Line.line_height * index
      text[query] = ''
      return x,y,text
    end
  end
  String_Operation_Module.add_markup(Markup_Current_Line)

  module Markup_Bottom
    module_function
    def query
      return /^\\bottom/
    end

    def transfer(bmp, x, y, text, match)
      text[query] = ''
      y = bmp.height - Markup_New_Line.line_height
      return x,y,text
    end
  end

  module Markup_Left
    module_function
    def query
      return /^\\left/
    end

    def transfer(bmp, x, y, text, match)
      if text =~ /^\\left\[([^\]]*)\]\./
        # ȗ`
        text[/^\\left\[([^\]]*)\]\./] = $1
      elsif text =~ /^\\left\(([^\)]*)\)\./
        # ȗ`^CvQ
        text[/^\\left\(([^\)]*)\)\./] = $1
      elsif text =~ /^\\left\[([^\]]*)\]/
        # {`
        text[/^\\left\[([^\]]*)\]/] = ''
      elsif text =~ /^\\left\(([^\]]*)\)/
        # {`^CvQ
        text[/^\\left\(([^\]]*)\)/] = ''
      else
        text[query] = ''
      end
      x = 0
      return x,y,text
    end
  end

  module Markup_Right
    module_function
    def query
      return /^\\right/
    end

    def transfer(bmp, x, y, text, match)
      dummy = ''
      if text =~ /^\\right\[([^\]]*)\]\./
        # ȗ`
        dummy = $1
        text[/^\\right\[([^\]]*)\]\./] = dummy
      elsif text =~ /^\\right\(([^\)]*)\)\./
        # ȗ`^CvQ
        dummy = $1
        text[/^\\right\(([^\)]*)\)\./] = dummy
      elsif text =~ /^\\right\[([^\]]*)\]/
        # {`
        dummy = $1
        text[/^\\right\[([^\]]*)\]/] = ''
      elsif text =~ /^\\right\(([^\]]*)\)/
        # {`^CvQ
        dummy = $1
        text[/^\\right\(([^\]]*)\)/] = ''
      else
        text[query] = ''
        dummy = text.split("\n")[0]
        dummy = '' if dummy.nil?
      end
      rect = bmp.text_size(dummy)
      x = bmp.width - rect.width
      return x,y,text
    end
  end

  module Markup_Center
    module_function
    def query
      return /^\\center/
    end

    def transfer(bmp, x, y, text, match)
      dummy = ''
      if text =~ /^\\center\[([^\]]*?)\]\./
        # ȗ`
        dummy = $1
        text[/^\\center\[([^\]]*?)\]\./] = dummy
      elsif text =~ /^\\center\(([^)]*?)\)\./
        # ȗ`^CvQ
        dummy = $1
        text[/^\\center\(([^)]*?)\)\./] = dummy
      elsif text =~ /^\\center\[([^\]]*?)\]/
        # {`
        dummy = $1
        text[/^\\center\[([^\]]*?)\]/] = ''
      elsif text =~ /^\\center\(([^)]*?)\)/
        # {`^CvQ
        dummy = $1
        text[/^\\center\(([^)]*?)\)/] = ''
      else
        text[query] = ''
        dummy = text.split("\n")[0]
        dummy = '' if dummy.nil?
      end
      rect = bmp.text_size(dummy)
      x = bmp.width / 2 - rect.width / 2
      return x,y,text
    end
  end

  module Markup_Center_Left
    module_function
    def query
      return /^\\center_left\[([^\]]*)\]/
    end

    def transfer(bmp, x, y, text, match)
      dummy = match[1]
      text[query] = ''
      rect = bmp.text_size(dummy)
      x = bmp.width / 2 - rect.width
      return x,y,text
    end
  end

  module Markup_Center_Right
    module_function
    def query
      return /^\\center_right\[([^\]]*)\]/
    end

    def transfer(bmp, x, y, text, match)
      dummy = match[1]
      text[query] = ''
      x = bmp.width / 2
      return x,y,text
    end
  end

  String_Operation_Module.add_markup(Markup_Bottom)
  String_Operation_Module.add_markup(Markup_Left)
  String_Operation_Module.add_markup(Markup_Right)
  String_Operation_Module.add_markup(Markup_Center_Left)
  String_Operation_Module.add_markup(Markup_Center_Right)
  String_Operation_Module.add_markup(Markup_Center)
end
