# CxgnhOW[ Event_Handling_Module
# Author:: fukuyama
# Date:: 2006/07/25
# Copyright:: Copyright (c) 2005,2006,2007 rgss-lib

# CxgnhOW[
module Event_Handling_Module

  # s[gnhO
  EVENT_HANDLING_REPEAT = 1
  # gK[nhO
  EVENT_HANDLING_TRIGGER = 2
  # nhNX
  class Handler
    attr_reader :name    # nh
    def initialize(name, trigger, handler)
      @name = name
      @trigger = trigger
      @handler = handler
    end

    def execute
      if @trigger.call
        @handler.call
        return true
      end
      return false
    end
  end

  # 
  def initialize(*arg)
    super(*arg)
    # nhOtO
    @event_handling_flag = 0
    setup_default_handler
  end

  # nhOtO
  attr_writer :event_handling_flag

  # s[gŃnhOꂽH
  def event_handling_repeat?
    @event_handling_flag == EVENT_HANDLING_REPEAT
  end

  # gK[ŃnhOꂽH
  def event_handling_trigger?
    @event_handling_flag == EVENT_HANDLING_TRIGGER
  end

  # ftHgnh[̍쐬
  def setup_default_handler
    handlers = {
      Input::LEFT  => 'input_left',
      Input::RIGHT => 'input_right',
      Input::UP    => 'input_up',
      Input::DOWN  => 'input_down',
      Input::A => 'input_a',
      Input::B => 'input_b',
      Input::C => 'input_c',
      Input::X => 'input_x',
      Input::Y => 'input_y',
      Input::Z => 'input_z',
      Input::L => 'input_l',
      Input::R => 'input_r',
    }
    handlers.each do |code,method_name|
      if self.class.method_defined?(method_name)
        add_input_handler(code,method_name)
      end
    end
    if self.class.method_defined?('active_event')
      @_active_event_prev_active = false
      trigger = proc do
        if (self.active and @_active_event_prev_active) or ((not self.active) and (not @_active_event_prev_active))
          @_active_event_prev_active = self.active
          return false
        end
        @_active_event_prev_active = self.active
        return true
      end
      add_handler('active_event',trigger,'active_event')
    end
  end

  # nh[̒ǉ
  def add_handler(name,trigger,handler)
    @_handlers = {} if @_handlers.nil?
    @_handlers[name] = [] if @_handlers[name].nil?
    case handler
    when Symbol
      handler = method handler
    when String
      handler = method handler
    end
    @_handlers[name].push Handler.new(name,trigger,handler)
  end

  # Cvbgnh[̒ǉ
  def add_input_handler(code,handler)
    if code.is_a?(Array)
      code.each do |c|
        add_input_handler(c,handler)
      end
      return
    end
    name = 'input' + code.to_s
    trigger = proc do
      if not self.active
        return false
      end
      if Input.trigger?(code)
        self.event_handling_flag = EVENT_HANDLING_TRIGGER
        return true
      end
      if Input.repeat?(code)
        self.event_handling_flag = EVENT_HANDLING_REPEAT
        return true
      end
      return false
    end
    @_input_handlers = {} if @_input_handlers.nil?
    @_input_handlers[name] = [] if @_input_handlers[name].nil?
    case handler
    when Symbol
      handler = method handler
    when String
      handler = method handler
    end
    @_input_handlers[name].push Handler.new(name,trigger,handler)
  end

  # nh[̍폜
  def remove_handler(name)
    @_handlers.delete(name)
  end

  # Cvbgnh[̍폜
  def remove_input_handler(code)
    @_input_handlers.delete('input' + code.to_s)
  end

  # nh[̍XV
  def _update_handler(handlers)
    if not handlers.nil?
      handlers.each do |name,handlers|
        result = false
        handlers.each do |handler|
          result |= handler.execute
          return if self.disposed?
        end
        return if result
      end
    end
  end

  def update_all_handler
    update_handler
    update_input_handler
  end

  def update_handler
    _update_handler(@_handlers)
  end

  def update_input_handler
    _update_handler(@_input_handlers)
  end
end
