#==============================================================================
#  Window_Shop_Actor_Status
#------------------------------------------------------------------------------
# ACe𔃂̃p[eBXe[^XEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Shop_Actor_Status < Window_Base
  #----------------------------------------------------------------------------
  # 
  #----------------------------------------------------------------------------
  def initialize()
    @actors = $game_party.actors
    @item_height = ITEM_HEIGHT

    # RecWvZ
    w = WINDOW_SHOP_STATUS_WIDTH
    h = (@actors.size + 1)* @item_height + 32
    x = 16
    y = 480 - h - 16
    super(x,y,w,h)
    self.contents = Bitmap.new(self.width - 32, self.height - 32)
    @item = nil

    # \WvZ
    w = self.contents.width
    @iw = self.contents.text_size('0').width * 4
    @cw = self.contents.text_size('').width
    @bx = w - @iw - 2
    @cx = @bx - @cw
    @ax = @cx - @iw - 2
  end
  #----------------------------------------------------------------------------
  # ACeݒ
  #----------------------------------------------------------------------------
  def set_item(item)
    if @item != item
      @item = item
      refresh
    end
  end
  #----------------------------------------------------------------------------
  # ĕ`
  #----------------------------------------------------------------------------
  def refresh
    self.contents.clear
    case @item
    when RPG::Item
      refresh_item
    when RPG::Weapon
      refresh_weapon
    when RPG::Armor
      refresh_armor
    end
  end
  #----------------------------------------------------------------------------
  # ^Cg
  #----------------------------------------------------------------------------
  def draw_title(title)
    w = self.contents.width
    h = @item_height
    x,y = 0,0
    self.contents.draw_text(x,y,w,h,title,1)
    y += h
  end
  #----------------------------------------------------------------------------
  # Xe[^X
  #----------------------------------------------------------------------------
  def draw_equip_status(index,a,b)
    y = index * @item_height + @item_height
    self.contents.draw_text(@ax, y, @iw, @item_height, a.to_s, 2)
    self.contents.draw_text(@cx, y, @cw, @item_height, '',   0)
    self.contents.draw_text(@bx, y, @iw, @item_height, b.to_s, 2)
  end
  #----------------------------------------------------------------------------
  # s
  #----------------------------------------------------------------------------
  def draw_no_equip_status(index)
    y = index * @item_height + @item_height
    self.contents.draw_text(0,y,self.contents.width,@item_height,'тłȂ',2)
  end
  #----------------------------------------------------------------------------
  # AN^[
  #----------------------------------------------------------------------------
  def draw_actor_name(index,actor)
    y = index * @item_height + @item_height
    self.contents.draw_text(0,y,self.contents.width,@item_height,actor.name,0)
  end
  #----------------------------------------------------------------------------
  # Xe[^X
  #----------------------------------------------------------------------------
  def draw_item_status(index,text)
    y = index * @item_height + @item_height
    self.contents.draw_text(0,y,self.contents.width,@item_height,text,2)
  end
  #----------------------------------------------------------------------------
  # ̕\
  #----------------------------------------------------------------------------
  def refresh_item
    # ^Cg
    draw_title('ǂ')

    @actors.each_index do |index|
      actor = @actors[index]

      # AN^[
      draw_actor_name(index,actor)

      count = actor.backpack.item_count_id(@item.id,Game_Item)
      if 0 < count
        draw_item_status(index,'Ă')
      else
        draw_item_status(index,'ĂȂ')
      end
    end
  end
  #----------------------------------------------------------------------------
  # ̕\
  #----------------------------------------------------------------------------
  def refresh_weapon
    # ^Cg
    draw_title($data_system.words.atk)
    @actors.each_index do |index|
      actor = @actors[index]

      # AN^[
      draw_actor_name(index,actor)

      if Item_Facade.equippable?(@item,actor)
        # łꍇ
        if actor.weapon.nil?
          draw_equip_status(index,0,@item.atk)
        else
          draw_equip_status(index,actor.weapon.atk,@item.atk)
        end
      else
        # łȂꍇ
        draw_no_equip_status(index)
      end
    end
  end
  #----------------------------------------------------------------------------
  # h̕\
  #----------------------------------------------------------------------------
  def refresh_armor
    # ^Cg
    draw_title($data_system.words.pdef)

    @actors.each_index do |index|
      actor = @actors[index]

      # AN^[
      draw_actor_name(index,actor)

      if Item_Facade.equippable?(@item,actor)
        # łꍇ
        if actor.equip_armors[@item.kind].nil?
          draw_equip_status(index,actor.base_pdef,actor.base_pdef + @item.pdef)
        else
          n = actor.base_pdef - actor.equip_armors[@item.kind].pdef
          draw_equip_status(index,actor.base_pdef,n + @item.pdef)
        end
      else
        # łȂꍇ
        draw_no_equip_status(index)
      end
    end
  end
end

end
