#==============================================================================
#  Window_Status_All
#------------------------------------------------------------------------------
# Xe[^XS
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Status_All < Window_Menu
  include Window_Tree_Module
  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize(parent)
    @item_height = ITEM_HEIGHT
    @item_width = 110
    super(parent)
    # ʒu̐ݒ
    screen_center
  end
  #--------------------------------------------------------------------------
  #  tbV
  #--------------------------------------------------------------------------
  def draw_text(x,y,text,align)
    self.contents.draw_text(x, y, @item_width, @item_height, text, align)
    return x, y + @item_height
  end
  def refresh_actor(x,y,actor)
    w = @item_width
    h = @item_height
    c = self.contents
    status_system_color = self.system_color
    if normal_color == self.crisis_color
      status_system_color = self.crisis_color
    elsif normal_color == self.knockout_color
      status_system_color = self.knockout_color
    end
    status_normal_color = self.normal_color

    c.font.color = status_normal_color

    # O
    (x,y) = draw_text(x,y, actor.name, 0)
    # go
    (x,y) = draw_text(x,y, $data_system.words.hp, 0)
    (x,y) = draw_text(x,y, actor.hp.to_s, 2)
    (x,y) = draw_text(x,y, actor.maxhp.to_s, 2)
    # lo
    (x,y) = draw_text(x,y, $data_system.words.sp, 0)
    (x,y) = draw_text(x,y, actor.sp.to_s, 2)
    (x,y) = draw_text(x,y, actor.maxsp.to_s, 2)
    # U
    (x,y) = draw_text(x,y, $data_system.words.atk,0)
    (x,y) = draw_text(x,y, actor.base_atk.to_s,2)
    # h
    (x,y) = draw_text(x,y, $data_system.words.pdef,0)
    (x,y) = draw_text(x,y, actor.base_pdef.to_s,2)
    # @h
    (x,y) = draw_text(x,y, $data_system.words.mdef,0)
    (x,y) = draw_text(x,y, actor.base_mdef.to_s,2)
    # ku
    c.draw_text(x, y, w, h, "Lv:", 0)
    c.draw_text(x, y, w, h, actor.level.to_s, 2)
  end
  def refresh
    self.contents.clear
    (x,y) = 0,0
    for actor in $game_party.actors
      refresh_actor(x,y,actor)
      x += _menu_width
    end
  end
  #--------------------------------------------------------------------------
  # EBhE
  #--------------------------------------------------------------------------
  def input_c
    decision_se
    dispose
  end

  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_width
    return _menu_width * 4
  end
  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_height
    return @item_height * 14
  end
  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_width
    return (@item_width+18)
  end
end

end
