#==============================================================================
#  Window_Skill
#------------------------------------------------------------------------------
# XLEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
module Battle

module Window_Target_Module
  def next_window(object)
    if object.scope == 1            # GP̂̏ꍇ
      window = Window_Target_Enemy.new(self)
      add_child window
      set_active_window(window.class)
    elsif object.scope == 2         # GŜ̏ꍇ
      window = get_window(Window_Actor_Command)
      window.targets = $game_troop.enemies
      top_window.dispose
    elsif [3,5].include? object.scope      # P̂̏ꍇ
      window = Window_Target_Actor.new(self)
      window.top  = self.top
      window.right = self.right
      add_child window
      set_active_window(window.class)
    elsif [4,6].include? object.scope      # Ŝ̏ꍇ
      window = get_window(Window_Actor_Command)
      window.targets = $game_party.actors
      top_window.dispose
    elsif 7 == object.scope                    # gp҂̏ꍇ
      window = get_window(Window_Actor_Command)
      window.targets = [window.actor]
      top_window.dispose
    end
  end
end

class Window_Skill < Window_Menu
  include Window_Tree_Module
  include Window_Target_Module

  #--------------------------------------------------------------------------
  # 
  #--------------------------------------------------------------------------
  def initialize(parent,actor)
    @actor = actor

    if not @actor.nil?
      skills = Skill_Facade.actor_battle_skills @actor
      skills.each do |skill|
        add_menu(skill, :select_skill)
      end
    end

    @index = 0
    @column_max = 2
    @row_max = 5

    super(parent)

    # EBhEʒu
    self.left = parent.left
    self.top = parent.top

    # ACewvEBhE쐬
    x = self.right
    y = self.top
    w = 640 - x - 16
    h = self.height
    @window_help = Window_Markup_Text.new(x,y,w,h)
    @window_help.back_opacity = WINDOW_BACK_OPACITY

    # qEBhEɒǉ
    add_child @window_help
    @window_help.visible = false

  end
  def skill
    return get_menu
  end
  #--------------------------------------------------------------------------
  # Cxgnh
  #--------------------------------------------------------------------------
  def input_b
    if Input.trigger?(Input::B)
      @index = -1
      cancel_se
      dispose
    end
  end
  def select_skill
    # SP Ȃꍇ͎gps
    if skill.sp_cost > @actor.sp
      # uU[ SE t
      buzzer_se
      return
    end
    get_window(Window_Actor_Command).skill = skill
    next_window(skill)
  end

  #--------------------------------------------------------------------------
  # XV
  #--------------------------------------------------------------------------
  def update
    super
    if not @window_help.disposed?
      @window_help.visible = (self.active or child_window_active?)
    end
    if (not Input.press?(Input::UP)) and (not Input.press?(Input::DOWN))
      if @index != @refresh_help_index and @index >= 0
        refresh_help
        @refresh_help_index = @index
      end
    end
  end
  #--------------------------------------------------------------------------
  # ĕ`
  #--------------------------------------------------------------------------
  def refresh
    super
    refresh_help
  end
  def refresh_help
    if (not @window_help.nil?) and (not @window_help.disposed?)
      if not self.skill.nil?
        text = self.skill.description
        text += "\\bottom"
        text += "\\center_left[#{skill.sp_cost}/]#{skill.sp_cost}/"
        text += "\\right[#{@actor.sp}]#{@actor.sp}"
        @window_help.set_text text
      else
        @window_help.set_text ""
      end
    end
  end

  #--------------------------------------------------------------------------
  # ڂ̕`
  #--------------------------------------------------------------------------
  def draw_menu_item(index,color,rect,skill)
    self.contents.font.color = color
    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
    self.contents.draw_text(rect, skill.name)
  end
  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_height
    return parent.contents.height
  end
  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_width
    max_width = _menu_width
    max_width += @cellspacing.x + @cellspacing.width
    return max_width * @column_max
  end
  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_width
    return BATTLE_WINDOW_SKILL_WIDTH
  end
end

end
end
