#==============================================================================
#  Phase_Party_Command
#------------------------------------------------------------------------------
# p[eBR}htF[Y
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
module Battle

class Phase_Party_Command
  include Battle_Phase_Base_Module

  def initialize
    # CtF[YtONA
    $game_temp.battle_main_phase = false
    # p[eBS̃ANVNA
    $game_party.clear_actions

    @window_party_command = Window_Party_Command.new

    # bZ[W\Ԋu퓬pǂ
    $scene.message_window.auto_message_interval = nil
    # Xe[^XEBhEɖ߂
    $scene.status_window.state_on
    # bZ[WEBhE悤ɂ
    $scene.message_window.fade_out_off = false
  end

  def update
    # R}h͕s\ȏꍇ
    unless $game_party.inputable?
      @window_party_command.dispose
      # CtF[YJn
      $scene.phase = Phase_Main.new
      return
    end

    # p[eBR}hEBhEXV
    @window_party_command.update

    # ꍇ
    if @window_party_command.disposed?
      # 
      if @window_party_command.battle?
        # CtF[YJn
        $scene.phase = Phase_Actor_Command.new
        return
      end
      # ɂ
      if @window_party_command.escape?
        update_phase2_escape
        return
      end
    end
  end

  #--------------------------------------------------------------------------
  #  t[XV (p[eBR}htF[Y : )
  #--------------------------------------------------------------------------
  def update_phase2_escape
    # Gl~[̑fϒlvZ
    enemies_agi = 0
    enemies_number = 0
    for enemy in $game_troop.enemies
      if enemy.exist?
        enemies_agi += enemy.agi
        enemies_number += 1
      end
    end
    if enemies_number > 0
      enemies_agi /= enemies_number
    end
    # AN^[̑fϒlvZ
    actors_agi = 0
    actors_number = 0
    for actor in $game_party.actors
      if actor.exist?
        actors_agi += actor.agi
        actors_number += 1
      end
    end
    if actors_number > 0
      actors_agi /= actors_number
    end
    # 
    success = rand(100) < 50 * actors_agi / enemies_agi
    # ̏ꍇ
    if success
      #  SE t
      $game_system.se_play($data_system.escape_se)
      # ogJnO BGM ɖ߂
      $game_system.bgm_play($game_temp.map_bgm)
      # ANVO
      action_log_escape(success)
      # ogI
#      battle_end(1)
    # s̏ꍇ
    else
      #  SE t
      $game_system.se_play($data_system.escape_se)
      # p[eBS̃ANVNA
      $game_party.clear_actions
      # CtF[YJn
      $scene.phase = Phase_Main.new
      # ANVO
      action_log_escape(success)
    end
  end

  def action_log_escape(success)
    # ANVʕ\Cxg
    action_event = Script_Event.new
    if $game_party.actors.size == 1
      action_event.message("\\clear\\PN[0]́@ɂI\\n")
    else
      action_event.message("\\clear\\PN[0]B́@ɂI\\n")
    end
    if success
      # ogI
      action_event.method_call(method(:battle_end),1)
    else
      action_event.message("\\scroll_lock@܂肱܂Ă܂I\\n")
    end
    action_event_start(action_event)
  end

end

end
end
