#==============================================================================
#  Properties_Interface_Module
#------------------------------------------------------------------------------
# vpeBC^tF[XW[
# Copyright (C) 2005 fukuyama
#==============================================================================

module Properties_Interface_Module
module Config
  BASE_DIR = 'Data/csv/'
end
end

module Properties_Interface_Module
  def default_properties
    return {}
  end
  def properties
    @properties = default_properties if @properties.nil?
    return @properties
  end
  def self.load_properties(array,id,filename)
    data_properties = load_data(filename)
    for object in array
      next if object.nil?
      properties = data_properties[object.method(id).call.to_s]
      next if properties.nil?
      object.properties.update properties
    end
  end
  def self.compile_properties(filename,data_filename)
    return if not $DEBUG
    csv_filename = Properties_Interface_Module::Config::BASE_DIR
    csv_filename += filename
    data_properties = {}
    if not FileTest.file?(data_filename)
      save_data(data_properties,data_filename)
    end
    if not FileTest.file?(csv_filename)
      return
    end
    File.open(csv_filename) do |file|
      keys = file.gets.chop.split("\t")
      while not file.eof?
        line = file.gets
        next if line =~ /^#/
        values = line.chop.split("\t",keys.size)
        id = values[0]
        data_properties[id] = {}
        for key in keys
          value = values.shift
          if (not value.nil?) and (not value.empty?)
            data_properties[id][key] = value
          end
        end
      end
    end
    save_data(data_properties,data_filename)
  end
end
