#==============================================================================
#  Game_Party_Module
#------------------------------------------------------------------------------
# }bvŃAN^[ړ
#==============================================================================

module Train_Actor

module Game_Party_Module
  attr_reader :characters
  def update_party_order
    dead_actor = false
    change = false
    for actor in actors
      if dead_actor and (not actor.dead?)
        change = true
        break
      end
      dead_actor |= actor.dead?
    end
    return if not change

    alive_actors = []
    dead_actors = []
    for actor in actors
      if actor.dead?
        dead_actors.push actor
      else
        alive_actors.push actor
      end
    end
    for actor in alive_actors + dead_actors
      actors.shift
      actors.push actor
    end
    $game_player.refresh
  end
  def setup_actor_character_sprites
    if @characters.nil?
      @characters = []
      for i in 1 ... TRAIN_ACTOR_SIZE_MAX
        @characters.push(Game_Party_Actor.new)
      end
    end
    for i in 1 ... TRAIN_ACTOR_SIZE_MAX
      @characters[i - 1].setup(actors[i])
    end
    if $scene.class.method_defined?('setup_actor_character_sprites')
      $scene.setup_actor_character_sprites(@characters)
    end
  end
  def update_party_actors
    update_party_order
    setup_actor_character_sprites
    transparent = $game_player.transparent
    if transparent == false
      if TRANSPARENT_SWITCH
        transparent = $game_switches[TRANSPARENT_SWITCHES_INDEX]
      end
    end
    for character in @characters
      character.transparent = transparent
      character.move_speed = $game_player.move_speed
      character.step_anime = $game_player.step_anime
      character.update
    end
  end
  def moveto_party_actors( x, y )
    setup_actor_character_sprites
    for character in @characters
      character.moveto( x, y )
    end
    if @move_list == nil
      @move_list = []
    end
    move_list_setup
  end
  def move_party_actors
    if @move_list == nil
      @move_list = []
      move_list_setup
    end
    @move_list.each_index do |i|
      if @characters[i] != nil
        case @move_list[i].type
          when Input::DOWN
            @characters[i].move_down(@move_list[i].args[0])
          when Input::LEFT
            @characters[i].move_left(@move_list[i].args[0])
          when Input::RIGHT
            @characters[i].move_right(@move_list[i].args[0])
          when Input::UP
            @characters[i].move_up(@move_list[i].args[0])
          when DOWN_LEFT
            @characters[i].move_lower_left
          when DOWN_RIGHT
            @characters[i].move_lower_right
          when UP_LEFT
            @characters[i].move_upper_left
          when UP_RIGHT
            @characters[i].move_upper_right
          when JUMP
            @characters[i].jump(@move_list[i].args[0],@move_list[i].args[1])
        end
      end
    end
  end
  class Move_List_Element
    def initialize(type,args)
      @type = type
      @args = args
    end
    def type() return @type end
    def args() return @args end
  end
  def move_list_setup
    for i in 0 .. TRAIN_ACTOR_SIZE_MAX
      @move_list[i] = nil
    end
  end
  def add_move_list(type,*args)
    @move_list.unshift(Move_List_Element.new(type,args)).pop
  end
  def move_down_party_actors(turn_enabled = true)
    move_party_actors
    add_move_list(Input::DOWN,turn_enabled)
  end
  def move_left_party_actors(turn_enabled = true)
    move_party_actors
    add_move_list(Input::LEFT,turn_enabled)
  end
  def move_right_party_actors(turn_enabled = true)
    move_party_actors
    add_move_list(Input::RIGHT,turn_enabled)
  end
  def move_up_party_actors(turn_enabled = true)
    move_party_actors
    add_move_list(Input::UP,turn_enabled)
  end
  def move_lower_left_party_actors
    move_party_actors
    add_move_list(DOWN_LEFT)
  end
  def move_lower_right_party_actors
    move_party_actors
    add_move_list(DOWN_RIGHT)
  end
  def move_upper_left_party_actors
    move_party_actors
    add_move_list(UP_LEFT)
  end
  def move_upper_right_party_actors
    move_party_actors
    add_move_list(UP_RIGHT)
  end
  def jump_party_actors(x_plus, y_plus)
    move_party_actors
    add_move_list(JUMP,x_plus, y_plus)
  end
end

end

class Game_Party
  include Train_Actor::Game_Party_Module
end
