#==============================================================================
#  Window_Actor_Menu_Status
#------------------------------------------------------------------------------
# 悳AN^[j[
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Actor_Menu_Status < Window_Actor_Menu_Base
  #----------------------------------------------------------------------------
  # 
  #----------------------------------------------------------------------------
  def initialize(parent,title)
    super(parent,title)

    # j[ǉ
    add_menu('񂢂', :all_status)
    pack

    # ʒu̐ݒ
    rect = parent.menu_rect(parent.index)
    self.top = parent.top + rect.y
    self.left = parent.left

    @actor_status_windows = []
    @all_status_windows = []

    # AN^[ȈՃXe[^X
    @window_actor_summary = Window_Status_Summary.new(self.actor)
    @window_actor_summary.left = self.right
    @window_actor_summary.top  = get_window(Window_Main_Menu).top
    @window_actor_summary.back_opacity = self.back_opacity
    @actor_status_windows.push @window_actor_summary

    # AN^[ڍ׃Xe[^X
    @window_actor_status_detail = Window_Status_Detail.new(self.actor)
    @window_actor_status_detail.left = @window_actor_summary.right
    @window_actor_status_detail.top  = @window_actor_summary.top
    @window_actor_status_detail.back_opacity = self.back_opacity
    @actor_status_windows.push @window_actor_status_detail

    # AN^[
    @window_actor_equip_item = Window_Status_Equip.new(self.actor)
    @window_actor_equip_item.left = @window_actor_summary.left
    @window_actor_equip_item.top  = @window_actor_summary.bottom
    @window_actor_equip_item.back_opacity = self.back_opacity
    @actor_status_windows.push @window_actor_equip_item

    # vCԃEBhE
    @window_playtime = Window_Status_PlayTime.new
    @window_playtime.left = self.right
    @window_playtime.top  = top_window.top
    @window_playtime.back_opacity = self.back_opacity
    @all_status_windows.push @window_playtime

    # S[hEBhE
    @window_gold = Window_Status_Gold.new
    @window_gold.left = self.right
    @window_gold.top  = @window_playtime.bottom
    @window_gold.back_opacity = self.back_opacity
    @all_status_windows.push @window_gold

    # XebvEBhE
    @window_steps = Window_Status_Steps.new
    @window_steps.left = self.right
    @window_steps.top  = @window_gold.bottom
    @window_steps.back_opacity = self.back_opacity
    @all_status_windows.push @window_steps

    self.actor_status_visible = true
  end

  def dispose
    @actor_status_windows.each do |window|
      window.dispose
    end
    @all_status_windows.each do |window|
      window.dispose
    end
    super
  end

  def all_status
    unsupport
  end

  def select_actor
    window = Window_Status_Skill.new(self)
    add_child window
    set_active_window(Window_Status_Skill)
  end

  def change_actor
    if self.actor.nil?
      self.all_status_visible = true
    else
      self.actor_status_visible = true
      @actor_status_windows.each do |window|
        window.actor = self.actor
      end
    end
  end

  def actor_status_visible=(visible)
    @actor_status_windows.each do |window|
      window.visible = visible
      window.z = self.z
    end
    @all_status_windows.each do |window|
      window.visible = (not visible)
      window.z = self.z
    end
  end

  def all_status_visible=(visible)
    self.actor_status_visible = (not visible)
  end
end

end
