#==============================================================================
#  Windowskin_Rule_Module
#------------------------------------------------------------------------------
# EBhEXLύXW[
#==============================================================================

module Windowskin_Rule_Module
  @@windowskin_rules = []
  #--------------------------------------------------------------------------
  # [NXǉ
  #--------------------------------------------------------------------------
  def add_windowskin_rule(klass)
    return if @@windowskin_rules.include?(klass)
    @@windowskin_rules.unshift klass
  end
  module_function :add_windowskin_rule

  #--------------------------------------------------------------------------
  # [XV
  #--------------------------------------------------------------------------
  def update(*arg)
    super(*arg)
    for rule in @@windowskin_rules
      if rule.change?
        if $game_system.windowskin_name != rule.windowskin_name
          $game_system.windowskin_name = rule.windowskin_name
        end
        return
      end
    end
  end
  def normal_color
    for rule in @@windowskin_rules
      if rule.change?
        if $game_system.windowskin_name != rule.windowskin_name
          $game_system.windowskin_name = rule.windowskin_name
        end
        if @normal_color != rule.normal_color
          @normal_color = rule.normal_color
        end
        return @normal_color
      end
    end
    return @normal_color
  end
end

class Window_Base
  include Windowskin_Rule_Module
  alias windowskin_rule_module_normal_color normal_color
  def normal_color
    color = super
    if color.nil?
      return windowskin_rule_module_normal_color
    end
    return color
  end
end
