#==============================================================================
#  Game_Actor_Properties
#------------------------------------------------------------------------------
# ėpAN^[
# Copyright (C) 2005 fukuyama
#==============================================================================

module Properties_Interface_Module
  def default_properties
    return {}
  end
  def properties
    @properties = default_properties if @properties.nil?
    return @properties
  end
  def self.load_properties(array,id,filename)
    data_properties = load_data(filename)
    for object in array
      next if object.nil?
      properties = data_properties[object.method(id).call.to_s]
      next if properties.nil?
      object.properties.update properties
    end
  end
  def self.compile_properties(csv_filename,data_filename)
    return if not $DEBUG
    data_properties = {}
    if FileTest.file? csv_filename
      File.open(csv_filename) do |file|
        keys = file.gets.chop.split("\t")
        while not file.eof?
          line = file.gets
          next if line =~ /^#/
          values = line.chop.split("\t",keys.size)
          id = values[0]
          data_properties[id] = {}
          for key in keys
            value = values.shift
            if (not value.nil?) and (not value.empty?)
              data_properties[id][key] = value
            end
          end
        end
      end
    end
    save_data(data_properties,data_filename)
  end
end

class Game_Actor
  include Properties_Interface_Module
end

module Game_Actor_Properties
  def setup_all_actor(key,vals)
    $data_actors.each_index do |i|
      if (not $game_actors[i].nil?) and
         (not vals[i].nil?)
        $game_actors[i].properties[key] = vals[i]
      end
    end
  end
  module_function :setup_all_actor

  module Game_Actor_Module
    PROPERTY_JOB = 'job'
    PROPERTY_SEX = 'sex'
    def default_properties
      properties = super
      properties[PROPERTY_JOB] = $data_classes[@class_id].name
      properties[PROPERTY_SEX] = 'HHH'
      return properties
    end
  end
end # module Game_Actor_Properties

class Game_Actor
  include Game_Actor_Properties::Game_Actor_Module
end
