#==============================================================================
#  Shake_Module
#------------------------------------------------------------------------------
# VFCNW[
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# VFCN邽߂̌vZs
#
#==============================================================================

module Shake_Module
  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize(*arg)
    super(*arg)
    @shake_power = 0
    @shake_speed = 0
    @shake_duration = 0
    @shake_direction = 1
    @shake_direction_mode = 1 # 1: 2:c
    @shake = 0
  end
  #--------------------------------------------------------------------------
  #  VFCN̊Jn
  #     power    : 
  #     speed    : 
  #     duration : 
  #     mode     : 
  #--------------------------------------------------------------------------
  def start_shake(power, speed, duration, mode)
    @shake_power = power
    @shake_speed = speed
    @shake_duration = duration
    @shake_direction_mode = mode
  end
  #--------------------------------------------------------------------------
  #  VFCNH
  #--------------------------------------------------------------------------
  def shake?
    return (@shake_duration > 0 or @shake != 0)
  end
  #--------------------------------------------------------------------------
  #  t[XV
  #--------------------------------------------------------------------------
  def update_shake
    if @shake_duration > 0 or @shake != 0
      delta = (@shake_power * @shake_speed * @shake_direction) / 10.0
      if @shake_duration <= 1 and @shake * (@shake + delta) < 0
        @shake = 0
      else
        @shake += delta
      end
      if @shake > @shake_power * 2
        @shake_direction = -1
      end
      if @shake < - @shake_power * 2
        @shake_direction = 1
      end
      if @shake_duration > 0
        @shake_duration -= 1
      end
      if block_given?
        yield(@shake_direction_mode == 1,@shake)
      else
        if @shake_direction_mode == 1
          self.ox = @shake
        else
          self.oy = @shake
        end
      end
    end
  end
end

class Shake_Util
  class Shake_Horizontal
    include Shake_Module
  end
  class Shake_Vertical
    include Shake_Module
  end
  #--------------------------------------------------------------------------
  # 
  #--------------------------------------------------------------------------
  def initialize
    @horizontal_shaker = Shake_Horizontal.new
    @vertical_shaker = Shake_Vertical.new
  end
  #--------------------------------------------------------------------------
  # VFCN̊Jn
  #   power    : 
  #   speed    : 
  #   duration : 
  #--------------------------------------------------------------------------
  def start_shake(power, speed, duration)
    if rand(100) < 50
      @horizontal_shaker.start_shake(power / 2, speed / 2, duration, 1)
      @vertical_shaker.start_shake(power, speed, duration, 2)
    else
      @horizontal_shaker.start_shake(power, speed, duration, 1)
      @vertical_shaker.start_shake(power / 2, speed / 2, duration, 2)
    end
  end
  #--------------------------------------------------------------------------
  # VFCNH
  #--------------------------------------------------------------------------
  def shake?
    return (@horizontal_shaker.shake? and @vertical_shaker.shake?)
  end
  #--------------------------------------------------------------------------
  # C^v^[pXV
  #--------------------------------------------------------------------------
  def update_interpreter
    result = (not shake?)
    @horizontal_shaker.update_shake &proc
    @vertical_shaker.update_shake &proc
    return result
  end
end
