#==============================================================================
#  Window_SaveData
#------------------------------------------------------------------------------
# Z[uf[^EBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_SaveData < Window_Menu
  include Window_Tree_Module
  #--------------------------------------------------------------------------
  # 
  #--------------------------------------------------------------------------
  def initialize(parent=nil)
    @index = 0
    @title = '`̏'
    @title_align = 1
    @savedatas = SaveData_Facade.load_index()
    @savedatas.each do |savedata|
      add_menu(savedata,:select_savedata)
    end
    super(parent)
    screen_center
  end
  #--------------------------------------------------------------------------
  # I
  #--------------------------------------------------------------------------
  def select_savedata
    dispose
  end
  #--------------------------------------------------------------------------
  # \p
  #--------------------------------------------------------------------------
  def message_display_string(index=@index)
    savedata = @savedatas[index]
    index_text = sprintf("%2dF",index + 1)
    name_text = savedata.name
    total_sec = savedata.playtime / Graphics.frame_rate
    hour = total_sec / 60 / 60
    min  = total_sec / 60 % 60
    sec  = total_sec % 60
    time_text = sprintf("%02d:%02d:%02d", hour, min, sec)
    return index_text + name_text + "@" + time_text
  end
  #--------------------------------------------------------------------------
  # ڂ̕`
  #--------------------------------------------------------------------------
  def draw_menu_item(index,color,menu_rect,savedata)
    self.contents.font.color = color
    self.contents.fill_rect(menu_rect, Color.new(0, 0, 0, 0))

    index_text = sprintf("%2dF",index + 1)
    index_rect = self.contents.text_size(index_text)
    index_rect.y = menu_rect.y + 2
    self.contents.draw_text( index_rect, index_text )

    if not savedata.nil?
      level_text = sprintf("Lv %2d ",savedata.lv)
      level_rect = self.contents.text_size(level_text)
      level_rect.x = menu_rect.width * 0.4 - level_rect.width
      level_rect.y = menu_rect.y + 2
      self.contents.draw_text( level_rect, level_text )

      name_text = savedata.name
      name_rect = Rect.new( index_rect.width,
                            menu_rect.y,
                            menu_rect.width * 0.4 - index_rect.width - level_rect.width,
                            menu_rect.height )
      self.contents.draw_text( name_rect, name_text )

      total_sec = savedata.playtime / Graphics.frame_rate
      hour = total_sec / 60 / 60
      min  = total_sec / 60 % 60
      sec  = total_sec % 60
      time_text = sprintf("%02d:%02d:%02d", hour, min, sec)
      time_rect = self.contents.text_size(time_text)
      time_rect.x = menu_rect.width - time_rect.width
      time_rect.y = menu_rect.y + 2
      self.contents.draw_text( time_rect, time_text )
      comment_text = savedata.comment
      comment_rect = Rect.new( menu_rect.width * 0.4,
                               menu_rect.y,
                               menu_rect.width * 0.4 - time_rect.width,
                               menu_rect.height )
      self.contents.draw_text( comment_rect, comment_text )
    else
      comment_text = 'gpĂ܂'
      comment_rect = Rect.new( index_rect.width,
                               menu_rect.y,
                               menu_rect.width - index_rect.width,
                               menu_rect.height )
      self.contents.draw_text( comment_rect, comment_text )
    end
  end
  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_width
    return _menu_width * 1
  end
  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_width
    return 544
  end
end

end
