#==============================================================================
#  SaveData_Facade
#------------------------------------------------------------------------------
# Z[uf[^p`oh
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

module SaveData_Facade
  @@indexfilename = 'SaveDataList.rxdata'

  module_function
  #--------------------------------------------------------------------------
  # Z[uf[^̓ǂݍ
  #--------------------------------------------------------------------------
  def load(index)
    scene_save = $scene
    scene_dumy = ::Scene_Load.new
    scene_dumy.on_decision(scene_dumy.make_filename(index))
    $scene = scene_save
    $game_temp.last_file_index = index
  end
  #--------------------------------------------------------------------------
  # Z[uf[^̏
  #--------------------------------------------------------------------------
  def save(index,name,lv,comment)
    savedatas = load_index
    savedata = Game_SaveData.new
    savedata.name     = name
    savedata.lv       = lv
    savedata.comment  = comment
    savedata.playtime = Graphics.frame_count
    savedatas[index] = savedata
    save_index(savedatas)

    scene_save = $scene
    scene_dumy = ::Scene_Save.new
    scene_dumy.on_decision(scene_dumy.make_filename(index))
    $scene = scene_save
    $game_temp.last_file_index = index
  end
  #--------------------------------------------------------------------------
  # Z[uf[^̍폜
  #--------------------------------------------------------------------------
  def delete(index)
    savedatas = load_index
    savedatas[index] = nil
    save_index(savedatas)

    scene_save = $scene
    scene_dumy = ::Scene_File.new(nil)
    File.delete(scene_dumy.make_filename(index))
    $scene = scene_save
  end
  #--------------------------------------------------------------------------
  # Z[uf[^CfbNX̓ǂݍ
  #--------------------------------------------------------------------------
  def load_index
    filename = @@indexfilename
    savedatas = [nil] * 4
    if FileTest.exist?(filename)
      File.open(filename, "rb") do |file|
        savedatas = Marshal.load(file)
      end
    end
    return savedatas
  end
  #--------------------------------------------------------------------------
  # Z[uf[^CfbNX̏
  #--------------------------------------------------------------------------
  def save_index(savedatas)
    filename = @@indexfilename
    File.open(filename, "wb") do |file|
      Marshal.dump(savedatas,file)
    end
    return savedatas
  end
end

end
