#==============================================================================
#  Window_Message
#------------------------------------------------------------------------------
# ͕\ɎgbZ[WEBhEłBiSprite_MessageΉj
#==============================================================================

class Window_Message
  attr_reader :sprite_message  # bZ[WXvCg
  attr_accessor :battle_message_position # 퓬̈ʒuݒ

  attr_accessor :fade_out_off # bZ[WEBhEtF[hAEgȂ
  attr_accessor :auto_message_interval # bZ[W\Ԋu

  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize
    line_height = 24 # Ps̍
    line_max    = 4  # \s

    super(48, 16, 640 - 96, (line_height * line_max) + 32)
    self.visible = false
    self.z = 9998
    self.active = false
    self.index = -1
    @fade_in = false
    @fade_out = false
    @contents_showing = false
    @battle_message_position = 0 # 퓬̈ʒuݒ
    # bZ[WXvCg쐬
    @sprite_message = Sprite_Message.new(self,line_max)
  end
  #--------------------------------------------------------------------------
  #  
  #--------------------------------------------------------------------------
  def dispose
    terminate_message
    $game_temp.message_window_showing = false
    if @input_number_window != nil
      @input_number_window.dispose
    end
    # bZ[WXvCgJ
    @sprite_message.dispose
    super
  end
  #--------------------------------------------------------------------------
  #  IEBhE̍쐬
  #--------------------------------------------------------------------------
  def create_window_message_command
    return Window_Message_Command.new
  end
  #--------------------------------------------------------------------------
  #  l̓EBhE̍쐬
  #--------------------------------------------------------------------------
  def create_window_message_input_number
    return Window_Message_InputNumber.new
  end
  #--------------------------------------------------------------------------
  #  S[hEBhE̍쐬
  #--------------------------------------------------------------------------
  def create_gold_window
    if @gold_window == nil
      @gold_window = Window_Gold.new
      @gold_window.x = 560 - @gold_window.width
      if $game_temp.in_battle
        @gold_window.y = 192
      else
        @gold_window.y = self.y >= 128 ? 32 : 384
      end
      @gold_window.opacity = self.opacity
      @gold_window.back_opacity = self.back_opacity
    end
  end
  #--------------------------------------------------------------------------
  #  bZ[WI
  #--------------------------------------------------------------------------
  def terminate_message
    self.active = false
    self.pause = false
    self.index = -1
    @sprite_message.terminate_message
    # \tONA
    @contents_showing = false
    # bZ[W R[obNĂ
    if $game_temp.message_proc != nil
      $game_temp.message_proc.call
    end
    # ́AIAl͂ɊւϐNA
    $game_temp.message_text = nil
    $game_temp.message_proc = nil
    $game_temp.choice_start = 99
    $game_temp.choice_max = 0
    $game_temp.choice_cancel_type = 0
    $game_temp.choice_proc = nil
    $game_temp.num_input_start = 99
    $game_temp.num_input_variable_id = 0
    $game_temp.num_input_digits_max = 0
    # S[hEBhEJ
    if @gold_window != nil
      @gold_window.dispose
      @gold_window = nil
    end
    # IEBhEJ
    if @command_window != nil
      @command_window.dispose
      @command_window = nil
    end
  end
  #--------------------------------------------------------------------------
  #  tbV
  #--------------------------------------------------------------------------
  def refresh
    # \҂̃bZ[Wꍇ
    if $game_temp.message_text != nil
      @sprite_message.message = $game_temp.message_text
    end
    # Ȉꍇ
    if $game_temp.choice_max > 0
      # IEBhE쐬
      @command_window = create_window_message_command
      @command_window.visible = false
      @command_window.active = false
      @command_window.z = self.z
      layout_window @command_window
    end
    # l͂̏ꍇ
    if $game_temp.num_input_variable_id > 0
      @input_number_window = create_window_message_input_number
      @input_number_window.visible = false
      @input_number_window.active = false
      @input_number_window.z = self.z
      layout_window @input_number_window
    end
  end
  #--------------------------------------------------------------------------
  #  EBhËʒuƕsx̐ݒ
  #--------------------------------------------------------------------------
  def reset_window
    if $game_temp.in_battle
      case @battle_message_position
      when 0  # 
        self.y = 16
      when 1  # 
        self.y = 160
      when 2  # 
        self.y = 480 - self.height - 16
      end
    else
      case $game_system.message_position
      when 0  # 
        self.y = 16
      when 1  # 
        self.y = 160
      when 2  # 
        self.y = 480 - self.height - 16
      end
    end
    if $game_system.message_frame == 0
      self.opacity = 255
    else
      self.opacity = 0
    end
    @sprite_message.y = self.y + 16
    self.back_opacity = 160
  end
  #--------------------------------------------------------------------------
  #  ̑EBhËʒuƕsx̐ݒ
  #--------------------------------------------------------------------------
  def layout_window(window)
    if window.nil?
      return
    end
    window.opacity = self.opacity
    window.back_opacity = self.back_opacity

    if $game_temp.in_battle or $game_system.message_position == 0

      # ɂ
      window.top  = self.bottom
      window.left = self.left

    elsif 1 < $game_system.message_position

      # ɂ
      window.bottom = self.top
      window.right  = self.right

    end
  end
  #--------------------------------------------------------------------------
  #  t[XV
  #--------------------------------------------------------------------------
  def update
    super
    # tF[hC̏ꍇ
    if @fade_in
      self.contents_opacity += 48
      if self.contents_opacity == 255
        @fade_in = false
      end
      @sprite_message.fade_in
      return
    end
    # bZ[WXvCgXV
    if @sprite_message.showing?
      @sprite_message.update
      return
    end
    # l̓EBhE̍XV
    if not @input_number_window.nil?
      if not @input_number_window.active
        $game_system.se_play(@input_number_window_se)
      end
      @input_number_window.visible = true
      @input_number_window.active = true
      @input_number_window.update
      # 
      if Input.trigger?(Input::C)
        $game_system.se_play($data_system.decision_se)
        $game_variables[$game_temp.num_input_variable_id] =
          @input_number_window.number
        $game_map.need_refresh = true
        # l̓EBhE
        @input_number_window.dispose
        @input_number_window = nil
        terminate_message
      end
      return
    end
    # IEBhEXV
    if not @command_window.nil?
      if not @command_window.active
        $game_system.se_play(@command_window_popup_se)
      end
      @command_window.visible = true
      @command_window.active = true
      @command_window.update
    end
    # bZ[W\̏ꍇ
    if @contents_showing
      # I̕\łȂ΃|[YTC\
      if $game_temp.choice_max == 0
        self.pause = true
        if @sprite_message.skip?
          terminate_message
          return
        end
      end
      # LZ
      if Input.trigger?(Input::B)
        if $game_temp.choice_max > 0 and $game_temp.choice_cancel_type > 0
          $game_system.se_play($data_system.cancel_se)
          $game_temp.choice_proc.call($game_temp.choice_cancel_type - 1)
          terminate_message
        end
      end
      # 
      if Input.trigger?(Input::C)
        if $game_temp.choice_max > 0
          $game_system.se_play($data_system.decision_se)
          $game_temp.choice_proc.call(@command_window.index)
        end
        terminate_message
      end
      if not @auto_message_interval.nil?
        if @auto_message_interval_count.nil?
          @auto_message_interval_count = @auto_message_interval
        end
        if @auto_message_interval_count <= 0
          @auto_message_interval_count = nil
          terminate_message
        else
          @auto_message_interval_count -= 1
        end
      end
      return
    end
    # tF[hAEgȊOŕ\҂̃bZ[WIꍇ
    if @fade_out == false and $game_temp.message_text != nil
      @contents_showing = true
      $game_temp.message_window_showing = true
      reset_window
      refresh
      Graphics.frame_reset
      if not self.visible
        @fade_in = true
      end
      self.visible = true
      self.contents_opacity = 0
      return
    end
    # \ׂbZ[WȂAEBhEԂ̏ꍇ
    if self.visible
      if @fade_out_off
        $game_temp.message_window_showing = false
        return
      end
      @fade_out = true
      self.opacity -= 48
      @sprite_message.fade_out
      if self.opacity == 0
        self.visible = false
        @fade_out = false
        $game_temp.message_window_showing = false
        @sprite_message.visible = false
        @sprite_message.clear
      end
      return
    end
  end
end
