#==============================================================================
#  Window_Title_Menu
#------------------------------------------------------------------------------
# cpp^Cgj[EBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Title_Menu < Window_Menu
  include Window_Tree_Module

  def initialize
    add_menu('`', :command_continue)
    add_menu('`̏', :command_new_game)
    add_menu('`̏', :command_delete_data)
    @index = 0
    super(nil)
    self.x = 16
    self.y = 16
    @text = ''
  end

  def update
    super
    if not @window_input.nil?
      if @window_input.disposed?
        if @window_input.text != ''
          window = Window_SaveData_Create.new(self,@window_input.text)
          add_child window
          set_active_window(window.class)
        end
        @window_input = nil
      end
    end
  end

  def command_new_game
    @window_input = Window_InputString.new('O͂Ă',INPUT_NAME_MAX_SIZE)
    add_child @window_input
    set_active_window(@window_input.class)
    @window_input.window_input_area.y = 16
    @window_input.y -= 32
  end

  def command_continue
    window = Window_SaveData_Continue.new(self)
    add_child window
    set_active_window(window.class)
  end

  def command_delete_data
    window = Window_SaveData_Delete.new(self)
    add_child window
    set_active_window(window.class)
  end
end

end
