#==============================================================================
#  Window_Main_Menu_Status
#------------------------------------------------------------------------------
# Cj[Xe[^X
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Main_Menu_Status < Window_Base

  FONT_SIZE = 22
  LINE_SIZE = 22
  ACTOR_WIDTH = 80
  ACTOR_WIDTH_SPACE = 16

  #--------------------------------------------------------------------------
  #  IuWFNg
  #--------------------------------------------------------------------------
  def initialize
    height = LINE_SIZE * 4 + 32
    width  = ACTOR_WIDTH * $game_party.actors.size
    width += ACTOR_WIDTH_SPACE * ($game_party.actors.size - 1) + 32
    x = 640 - width - 16
    y = 480 - height - 16
    super(x, y, width, height)
    self.contents = Bitmap.new(self.width - 32, self.height - 32)
    refresh
  end
  #--------------------------------------------------------------------------
  #  XV
  #--------------------------------------------------------------------------
  def update
    super
    update_status = 0
    $game_party.actors.each do |actor|
      update_status += actor.hp + actor.sp + actor.level
    end
    if @refresh_status != update_status
      refresh
    end
  end
  #--------------------------------------------------------------------------
  #  tbV
  #--------------------------------------------------------------------------
  def refresh
    self.contents.clear
    self.contents.font.size = FONT_SIZE
    @refresh_status = 0
    for i in 0 ... $game_party.actors.size
      x = ACTOR_WIDTH * i + ACTOR_WIDTH_SPACE * i
      y = 0
      actor = $game_party.actors[i]
      self.contents.font.size -= 2
      self.contents.font.color = normal_color
      self.contents.draw_text(x, y, ACTOR_WIDTH + ACTOR_WIDTH_SPACE, LINE_SIZE, actor.name, 0)
      self.contents.font.size += 2
      y += LINE_SIZE
      self.contents.font.color = system_color
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, "HP", 0)
      self.contents.font.color = normal_color
      self.contents.font.color = knockout_color if actor.hp == 0
      self.contents.font.color = crisis_color   if actor.hp <= actor.maxhp / 4
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, actor.hp.to_s, 2)
      y += LINE_SIZE
      self.contents.font.color = system_color
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, "SP", 0)
      self.contents.font.color = normal_color
      self.contents.font.color = crisis_color   if actor.sp <= actor.maxsp / 4
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, actor.sp.to_s, 2)
      y += LINE_SIZE
      self.contents.font.color = system_color
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, "Lv:", 0)
      self.contents.font.color = normal_color
      self.contents.draw_text(x, y, ACTOR_WIDTH, LINE_SIZE, actor.level.to_s, 2)
      @refresh_status += actor.hp + actor.sp + actor.level
    end
  end
end

end
