#==============================================================================
#  String_Operation_Module
#------------------------------------------------------------------------------
# 񐧌
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# BitmapWindowSpriteincludełi\j
#
#==============================================================================

module String_Operation_Module

  @@markup_operation_list = [] # p}[NAbvNXXg

  #--------------------------------------------------------------------------
  #  }[NAbvNXǉ
  #--------------------------------------------------------------------------
  def add_markup(klass)
    return if @@markup_operation_list.include?(klass)
    @@markup_operation_list.push klass
  end
  module_function :add_markup

  #--------------------------------------------------------------------------
  #  }[NAbv
  #--------------------------------------------------------------------------
  def markup_operation(x,y,text)
    case self
    when Bitmap
      bmp = self
    when Window
      bmp = self.contents
    when Sprite
      bmp = self.bitmap
    else
      return x,y,text
    end
    loop do
      replace = false
      @@markup_operation_list.each do |klass|
        if text =~ klass.query
          x,y,text = klass.transfer(bmp, x, y, text, $~)
          replace = true
        end
      end
      break if not replace
    end
    return x,y,text
  end
  private :markup_operation
end
