#==============================================================================
#  Window_Tree_Module
#------------------------------------------------------------------------------
# KwIȃEBhEǗ
# Copyright (C) 2005 fukuyama
#==============================================================================

module Window_Tree_Module
  attr_reader :parent
  #---------------------------------------------------------------------------
  # 
  #---------------------------------------------------------------------------
  def initialize(parent, *arg)
    @parent = parent
    @child_windows = []
    super(*arg)
  end
  #---------------------------------------------------------------------------
  # gbvEBhE̎擾
  #---------------------------------------------------------------------------
  def top_window
    if self.parent.nil?
      return self
    end
    return self.parent.top_window
  end
  #---------------------------------------------------------------------------
  # c[ɂw肳ꂽEBhÊ݂ANeBuɂ
  #---------------------------------------------------------------------------
  def set_active_window(klass)
    top_window._set_active_window(klass)
  end
  def _set_active_window(klass)
    self.active = self.is_a?(klass)
    @child_windows.each do |window|
      if not window.disposed?
        if window.is_a? Window_Tree_Module
          window._set_active_window(klass)
        else
          window.active = window.is_a?(klass)
        end
      end
    end
  end
  #---------------------------------------------------------------------------
  # c[ɂw肳ꂽEBhE擾
  #---------------------------------------------------------------------------
  def get_window(klass)
    return top_window._get_window(klass)
  end
  def _get_window(klass)
    return self if self.is_a?(klass)
    @child_windows.each do |window|
      if not window.disposed?
        if window.is_a? Window_Tree_Module
          return window._get_window(klass)
        else
          return window if window.is_a?(klass)
        end
      end
    end
    return nil
  end
  #---------------------------------------------------------------------------
  # ANeBuEBhE̎擾
  #---------------------------------------------------------------------------
  def get_active_window
    return top_window._get_active_window
  end
  def _get_active_window
    return self if self.active
    @child_windows.each do |window|
      if not window.disposed?
        if window.is_a? Window_Tree_Module
          return window._get_active_window
        else
          return window if window.active
        end
      end
    end
    return nil
  end
  #---------------------------------------------------------------------------
  # SĂ̂yCfbNXXV
  #---------------------------------------------------------------------------
  def refresh_z_index
    if (not parent.nil?) and self.z <= parent.z
      self.z = parent.z + 10
    end
    @child_windows.each do |window|
      if not window.disposed?
        if window.is_a? Window_Tree_Module
          window.refresh_z_index
        else
          window.z = self.z + 10
        end
      end
    end
  end
  #---------------------------------------------------------------------------
  # qEBhE̒ǉ
  #---------------------------------------------------------------------------
  def add_child(window)
    @child_windows.push window
    refresh_z_index
    return window
  end
  #---------------------------------------------------------------------------
  # XV
  #---------------------------------------------------------------------------
  def update
    update_child_windows
    return if disposed?
    super
    return if disposed?
    update_handler
    return if disposed?
    if top_window == self
      active_window = get_active_window
      if active_window.is_a? Event_Handling_Module
        active_window.update_input_handler
      end
    end
  end
  #---------------------------------------------------------------------------
  # j
  #---------------------------------------------------------------------------
  def dispose
    @child_windows.each do |window|
      if not window.disposed?
        window.dispose
      end
    end
    @child_windows.clear
    super
  end
  #---------------------------------------------------------------------------
  # qEBhEɃANeBuȕ邩H
  #---------------------------------------------------------------------------
  def child_window_active?
    result = false
    @child_windows.each do |window|
      if not window.disposed?
        if window.is_a? Window_Tree_Module
          result = (window.active or window.child_window_active?)
        else
          result = window.active
        end
        if result
          break
        end
      end
    end
    return result
  end
  #---------------------------------------------------------------------------
  # qEBhE̍XV
  #---------------------------------------------------------------------------
  def update_child_windows
    @child_windows.dup.each do |window|
      if not window.disposed?
        window.update
      end
      # updatedisposeĂꍇ
      if window.disposed?
        @child_windows.delete window
        if not disposed?
          if get_active_window.nil?
            self.active = (not child_window_active?)
          end
        end
      end
    end
  end
end
