#==============================================================================
#  Sprite_Cursor
#------------------------------------------------------------------------------
# J[\XvCg
# Copyright (C) 2005 fukuyama
#==============================================================================

class Sprite_Cursor < RPG::Sprite
  DEFAULT_CURSOR_ICON = RPG::Cache.icon('037-Item06')

  def initialize(viewport)
    super(viewport)
    if @cursor_bitmap.nil?
      @cursor_bitmap = DEFAULT_CURSOR_ICON
    end
    @_blink_count = 0
    self.bitmap = @cursor_bitmap
  end
  def white_blink_on
    unless @_white_blink
      @_white_blink = true
      @_blink_count = 0
    end
  end
  def white_blink_off
    if @_white_blink
      @_white_blink = false
      self.color.set(0, 0, 0, 0)
    end
  end
  def update
    if @_white_blink
      @_blink_count = (@_blink_count + 1) % 32
      if @_blink_count < 16
        alpha = (16 - @_blink_count) * 6
      else
        alpha = (@_blink_count - 16) * 6
      end
      self.color.set(0, 0, 0, alpha)
    end
    super
  end
end
