/*
 * Decompiled with CFR 0.152.
 */
package osm.surveyor.matchtime;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Restamp
extends Thread {
    public static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss z";
    public Exception ex = null;
    protected static final String LOGGING_PROPERTIES_DATA = "handlers=java.util.logging.ConsoleHandler\n.level=FINEST\njava.util.logging.ConsoleHandler.level=INFO\njava.util.logging.ConsoleHandler.formatter=osm.jp.gpx.YuuLogFormatter";
    Path imgDir;
    Path outDir;
    Date baseTime1;
    Date baseTime2;
    Path baseFile1;
    Path baseFile2;
    public static ResourceBundle i18n = ResourceBundle.getBundle("i18n");

    public static void main(String[] argv) throws Exception {
        Path imgDir;
        if (argv.length < 5) {
            System.out.println("java osm.surveyor.matchtime.Restamp <imgDir> <baseFile1> <timeStr1> <baseFile2> <timeStr2>");
            System.out.println("java osm.surveyor.matchtime.Restamp <imgDir> <baseFile1> <timeStr1> <baseFile2> <timeStr2> <output dir>");
            return;
        }
        Path outDir = imgDir = Paths.get(argv[0], new String[0]);
        if (argv.length >= 6) {
            outDir = Paths.get(argv[5], new String[0]);
        }
        Path baseFile1 = Paths.get(imgDir.toString(), argv[1]);
        SimpleDateFormat df1 = new SimpleDateFormat(TIME_PATTERN);
        Date baseTime1 = df1.parse(argv[2]);
        Date baseTime2 = df1.parse(argv[4]);
        Restamp obj = new Restamp();
        Path baseFile2 = Paths.get(imgDir.toString(), argv[3]);
        if (obj.setUp(imgDir, baseFile1, baseTime1, baseFile2, baseTime2, outDir)) {
            obj.start();
            try {
                obj.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (obj.ex != null) {
                throw obj.ex;
            }
        }
    }

    public boolean setUp(Path imgDir, Path baseFile1, Date baseTime1, Path baseFile2, Date baseTime2, Path outDir) throws Exception {
        this.imgDir = imgDir;
        this.outDir = outDir;
        this.baseTime1 = baseTime1;
        this.baseTime2 = baseTime2;
        this.baseFile1 = baseFile1;
        this.baseFile2 = baseFile2;
        if (!Files.exists(imgDir, new LinkOption[0])) {
            System.out.println(i18n.getString("msg.200"));
            return false;
        }
        if (!Files.isDirectory(imgDir, new LinkOption[0])) {
            System.out.println(i18n.getString("msg.210"));
            return false;
        }
        if (Files.exists(outDir, new LinkOption[0])) {
            if (!Files.isDirectory(outDir, new LinkOption[0])) {
                System.out.println(i18n.getString("msg.270"));
                return false;
            }
        } else {
            try {
                Files.createDirectories(outDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.out.println(i18n.getString("msg.275"));
                return false;
            }
        }
        if (!Files.isWritable(outDir)) {
            System.out.println(i18n.getString("msg.275"));
            return false;
        }
        if (!Files.exists(baseFile1, new LinkOption[0])) {
            System.out.println(i18n.getString("msg.220"));
            return false;
        }
        if (!Files.isRegularFile(baseFile1, new LinkOption[0])) {
            System.out.println(i18n.getString("msg.230"));
            return false;
        }
        if (!Files.exists(baseFile2, new LinkOption[0])) {
            System.out.println(i18n.getString("msg.240"));
            return false;
        }
        if (!Files.isRegularFile(baseFile2, new LinkOption[0])) {
            System.out.println(i18n.getString("msg.250"));
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        int bCount1 = 0;
        int bCount2 = 0;
        boolean base1 = false;
        boolean base2 = false;
        ArrayList<Path> jpgFiles = new ArrayList<Path>();
        try (Stream<Path> files = Files.list(Paths.get(this.imgDir.toString(), new String[0]));){
            List sortedList = files.sorted(Comparator.naturalOrder()).collect(Collectors.toList());
            for (Path p : sortedList) {
                String filename;
                if (!Files.exists(p, new LinkOption[0]) || !Files.isRegularFile(p, new LinkOption[0]) || !(filename = p.getFileName().toString()).toUpperCase().endsWith(".JPG")) continue;
                jpgFiles.add(p);
                bCount1 += base1 ? 0 : 1;
                bCount2 += base2 ? 0 : 1;
                if (p.getFileName().equals(this.baseFile1.getFileName())) {
                    base1 = true;
                }
                if (!p.getFileName().equals(this.baseFile2.getFileName())) continue;
                base2 = true;
            }
            if (!jpgFiles.isEmpty()) {
                SimpleDateFormat df2 = new SimpleDateFormat(TIME_PATTERN);
                long span = this.baseTime2.getTime() - this.baseTime1.getTime();
                span /= (long)(bCount2 - bCount1);
                int i = 0;
                System.out.println("-------------------------------");
                System.out.println("Update last modified date time.");
                for (Path jpgFile : jpgFiles) {
                    long deltaMsec = (long)(i - (bCount1 - 1)) * span;
                    ++i;
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.baseTime1);
                    cal.add(14, (int)deltaMsec);
                    System.out.println(String.format("\t%s --> %s", df2.format(cal.getTime()), jpgFile.getFileName()));
                    try {
                        Path outFile;
                        if (this.outDir.equals(this.imgDir)) {
                            outFile = jpgFile;
                        } else {
                            outFile = Paths.get(this.outDir.toString(), jpgFile.toFile().getName());
                            Files.copy(jpgFile, outFile, new CopyOption[0]);
                        }
                        outFile.toFile().setLastModified(cal.getTimeInMillis());
                    }
                    catch (Exception e) {
                        System.out.println("[ERROR] Can not convert." + e.toString());
                    }
                }
                System.out.println("-------------------------------");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.ex = new Exception(e);
        }
    }
}

