<?php
/* ----------------------------------------------------
 * Response
 * @version 1.0.0
 * @author ken Kikuchi
 * http://www.i-approach.com/
 * 
 * Licensed under the MIT licenses.
*/ 

class UsersController extends AppController {

	var $name = 'Users';
	var $helpers = array('Time');
	var $components = array('RoleCheck');

	function beforeFilter() {
    	$this->Auth->authorize = 'controller';
		
		if($this->User->find('count') == 0) {
			$this->Auth->allow('add');
    	}
    	
  		$this->Auth->loginRedirect = array('controller' => 'posts', 'action' => 'index');
	}
  
  //Login
  function login(){
  }

  //Logout
  function logout(){
    $this->Session->setFlash('You have logged out successfully.');
 	$this->Auth->logout();
  }

  function isAuthorized () {
    $user = $this->Auth->user();
    $user['User']['last'] = date('Y-m-d H:i:s');
    $this->User->save($user['User']);

    return true;
  }


  //User add
  function add() {
		if($this->User->find('count') != 0) {
			if(!$this->RoleCheck->checkUser('add')) {
				$this->Session->setFlash(__('Invalid Access', true));
				$this->redirect(array('controller'=> 'posts','action' => 'index'));
    		}
    	}

    if (!empty($this->data)) {
    	$this->User->set($this->data);
    	if ($this->User->isUnique(array('username'))) {
        	$this->User->create();
        	$this->User->save($this->data['User']);
        	$this->redirect(array('action' => 'index'));
        }else{
        	$this->Session->setFlash(__('The username already exist.', true));
			$this->redirect(array('action' => 'index'));
        }
    }
	if($this->User->find('count') == 0) {
		$this->set('parentid', 0);
		$this->set('role', 1);
		$this->set('number', 0);
   	}else{
		$this->set('parentid', $this->Auth->user('id'));
	    switch ($this->Auth->user('role')) {
    		case 1:
        		$this->set('role', 2);
        		$this->set('number', 100);
        		break;
    		case 2:
        		$this->set('role', 4);
        		$this->set('number', 0);
        		break;
    		case 3:
        		$this->set('role', 5);
        		$this->set('number', 0);
        		break;
    	}
   	}
  }

	function index() {
		if(!$this->RoleCheck->checkUser('index')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		$this->User->recursive = 1;
		$this->set('user', $this->User->read(null, $this->Auth->user('id')));
	}

	function view($id = null) {
		if(!$this->RoleCheck->checkUser('view')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		$this->User->recursive = -1;
   		if($this->Auth->user('role') == 4) {
			$this->set('user', $this->User->read(null, $this->Auth->user('id')));
   		}else{
			if(!empty($id)) {
				$this->set('user', $this->User->read(null, $id));
			}else{
				$this->set('user', $this->User->read(null, $this->Auth->user('id')));
   			}
   		}
	}

	function edit($id = null) {
		if(!$this->RoleCheck->checkUser('edit')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid user', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) {

			if ($this -> data["User"]["new_password"]) {
   				$this -> data["User"]["password"] = $this -> Auth -> password($this -> data['User']['new_password']);
			}
			
			$data = $this->data;
			
			if ($this->User->save($data)) {
				$this->Session->setFlash(__('The design has been saved. Please log in again to apply a change. ', true));
				$this->redirect(array('action' => 'view',$id));
			} else {
				$this->Session->setFlash(__('The user could not be saved. Please, try again.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->User->read(null, $id);
		}
	}


	function delete($id = null) {
		if(!$this->RoleCheck->checkUser('delete')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for user', true));
			$this->redirect(array('action'=>'index'));
		}else{
			$requestPid = $this->User->read('parent_id', $id);
			if ($requestPid['User']['parent_id'] != $this->Auth->user('id')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('action'=>'index'));
			}

		}
		if ($this->User->delete($id)) {
			$this->Session->setFlash(__('User deleted', true));
			$this->redirect(array('action'=>'index'));
		}
		$this->Session->setFlash(__('User was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
}
?>