<?php
/* ----------------------------------------------------
 * Response
 * @version 1.0.0
 * @author ken Kikuchi
 * http://www.i-approach.com/
 * 
 * Licensed under the MIT licenses.
*/ 

class ResponsesController extends AppController {

	var $name = 'Responses';
	var $uses = array('Response','Answer');
	var $components = array('RoleCheck');
	var $helpers = array('Time');

	function index() {
		if(!$this->RoleCheck->checkResponse('index')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		$this->Response->recursive = 0;
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$this->set('responses', $this->paginate('Response', array(array('Response.parentid LIKE' => $this->Auth->user('id')))));
	}

	function view($id = null) {
		if(!$this->RoleCheck->checkResponse('view')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid response', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('response', $this->Response->read(null, $id));
	}

	function add($id = null) {
		if(!$this->RoleCheck->checkResponse('add')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid response', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) {
			$this->Response->create();
			if ($this->Response->save($this->data)) {
				$this->Session->setFlash(__('The response has been saved', true));
				$question_id = $this->Answer->read('question_id', $id);
				$this->redirect(array('controller' => 'questions','action' => 'view',$question_id['Answer']['question_id']));
			} else {
				$this->Session->setFlash(__('The response could not be saved. Please, try again.', true));
				$question_id = $this->Answer->read('question_id', $id);
				$this->redirect(array('controller' => 'questions','action' => 'view',$question_id['Answer']['question_id']));
			}
		}
		$answers = $this->Response->Answer->find('list');
		$users = $this->Response->User->find('list');
		$this->set(compact('answers', 'users'));
	}

	function edit($id = null) {
		if(!$this->RoleCheck->checkResponse('edit')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid response', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->Response->save($this->data)) {
				$this->Session->setFlash(__('The response has been saved', true));
				$question_id = $this->Response->read('question_id', $id);
				$this->redirect(array('controller' => 'questions','action' => 'view',$question_id['Response']['question_id']));
			} else {
				$this->Session->setFlash(__('The response could not be saved. Please, try again.', true));
				$question_id = $this->Answer->read('question_id', $id);
				$this->redirect(array('controller' => 'questions','action' => 'view',$question_id['Answer']['question_id']));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Response->read(null, $id);
		}
	}

	function delete($id = null) {
		if(!$this->RoleCheck->checkResponse('delete')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for response', true));
			$this->redirect(array('action'=>'index'));
		}
		$question_id = $this->Response->read('question_id', $id);
		if ($this->Response->delete($id)) {
			$this->Session->setFlash(__('Response deleted', true));
			$this->redirect(array('controller' => 'questions','action' => 'view',$question_id['Response']['question_id']));
		}
		$this->Session->setFlash(__('Response was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
}
?>