/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

import jp.highwide.resourcechecker.ResourceCheckerPlugin;
import jp.highwide.resourcechecker.action.ToggleNatureAction;
import jp.highwide.resourcechecker.dialog.ErrorDialog;
import jp.highwide.resourcechecker.widgets.CheckBoxListComposit;
import jp.highwide.resourcechecker.widgets.CheckBoxListEditComposit;
import jp.highwide.resourcechecker.widgets.CheckBoxListEditResourceComposit;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

/**
 * ResourceCheckervOCPropertyPageNXB
 */
public class ResourceCheckerPage extends PropertyPage implements
		IWorkbenchPropertyPage {
	/** `FbNWbNJARURI ID */
	public static final String ID_CHECKER_URI = "id.checker.uri";

	/** `FbNΏۃt@C ID */
	public static final String ID_INCLUDE_LIST = "id.include.list";

	/** O`FbNΏۃt@C ID */
	public static final String ID_EXCLUDE_LIST = "id.exclude.list";

	/** `FbNWbNNX ID */
	public static final String ID_CHECK_LIST = "id.check.list";

	/** `FbNWbNJar̃ftHgURI */
	public static final String DEFAULT_CHECKER_URI = "http://resourcechecker.sourceforge.jp/sample/checklogic.jar";

	private static final String PROPERTIES_FILENAME = ".jp.highwide.resourcechecker.properties";

	private Text checkerURIText = null;

	private Button fileOpenBox = null;

	private Button enableCheckBox = null;

	private CheckBoxListEditComposit includeListEditor = null;

	private CheckBoxListEditComposit excludeListEditor = null;

	private CheckLogicComposite checkListEditor = null;

	private static Image IMG_OPEN_ICON = PlatformUI.getWorkbench()
			.getSharedImages().getImage(ISharedImages.IMG_OBJ_FOLDER);

	/**
	 * vpeBy[W̃Rec쐬B
	 * @see PreferencePage#createContents(Composite)
	 */
	@Override
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = GridData.FILL;
		composite.setLayoutData(gridData);

		IProject project = null;
		try {
			project = getProject();
		} catch (CoreException e) {
			ResourceCheckerPlugin.log(e);
		}
		enableCheckBox = new Button(composite, SWT.CHECK);
		enableCheckBox.setText("rhɎ`FbN");
		enableCheckBox.setSelection(ToggleNatureAction.isNature(project));
		Label label;
		label = new Label(composite, SWT.NONE);
		label.setText("`FbNWbNJARURL");

		Composite uriComposite = new Composite(composite, SWT.NONE);
		uriComposite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		GridLayout uriLayout = new GridLayout();
		uriLayout.numColumns = 2;
		uriComposite.setLayout(uriLayout);

		checkerURIText = new Text(uriComposite, SWT.SINGLE | SWT.BORDER);
		GridData gridDataFillH = new GridData(GridData.FILL_HORIZONTAL);
		gridDataFillH.widthHint = 150;
		checkerURIText.setLayoutData(gridDataFillH);
		fileOpenBox = new Button(uriComposite, SWT.NONE);
		fileOpenBox.setText("Q");
		fileOpenBox.setImage(IMG_OPEN_ICON);
		fileOpenBox.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent event) {
				FileDialog dialog = new FileDialog(getShell());
				dialog.setFilterExtensions(new String[] { "*.jar", "*.*" });
				String filePath = dialog.open();
				if (filePath != null) {
					try {
						File f = new File(filePath);
						URL url = f.toURL();
						String urlStr = url.toString().replaceAll(" ", "%20");
						checkerURIText.setText(urlStr);
					} catch (Exception e) {
						Exception ex = new Exception("t@CpX(" + filePath
								+ ")URLɕϊł܂łB");
						ErrorDialog errorBox = new ErrorDialog(getShell(), ex);
						errorBox.open();
					}
				}
			}
		});

		GridData gridDataFillBoth = new GridData(GridData.FILL_BOTH);
		gridDataFillBoth.heightHint = 100;

		checkListEditor = new CheckLogicComposite(composite,
				"`FbNWbNNX",
				checkerURIText);
		checkListEditor.setLayoutData(gridDataFillBoth);

		includeListEditor = new CheckBoxListEditResourceComposit(composite,
				"`FbNΏۃt@C(:/ProjectName/src/.*\\.java)",
				project);
		includeListEditor.setLayoutData(gridDataFillBoth);

		excludeListEditor = new CheckBoxListEditResourceComposit(composite,
				"O`FbNΏۃt@C(:/ProjectName/test/.*Test\\.java)",
				project);
		excludeListEditor.setLayoutData(gridDataFillBoth);

		Properties p = new Properties();
		p = getProperties(project);
		checkerURIText.setText(p.getProperty(ID_CHECKER_URI,
				DEFAULT_CHECKER_URI));
		includeListEditor.setValue(p.getProperty(ID_INCLUDE_LIST,
				CheckBoxListComposit.LIST_DELIMITOR));
		excludeListEditor.setValue(p.getProperty(ID_EXCLUDE_LIST,
				CheckBoxListComposit.LIST_DELIMITOR));
		checkListEditor.setValue(p.getProperty(ID_CHECK_LIST,
				CheckBoxListComposit.LIST_DELIMITOR));

		return composite;
	}

	/**
	 * w肳ꂽvWFNgPropertiesԋpB
	 * @param project vWFNg
	 * @return vWFNgProperties
	 */
	public static Properties getProperties(IProject project) {
		Properties properties = new Properties();
		FileInputStream fis = null;
		try {
			File file = getPropertyFile(project);
			if (!file.exists()) {
				return properties;
			}
			fis = new FileInputStream(file);
			properties.load(fis);

		} catch (Throwable t) {
			ResourceCheckerPlugin.log(t);
		} finally {
			if (fis != null) {
				try {
					fis.close();
				} catch (IOException e) {
					ResourceCheckerPlugin.log(e);
				}
			}
		}
		return properties;
	}

	/**
	 * `FbNWbNJARURIԋpB
	 * @param properties ݒl
	 * @return `FbNWbNJARURI
	 */
	public static String getLogicURI(Properties properties) {
		return properties.getProperty(ID_CHECKER_URI, DEFAULT_CHECKER_URI);
	}

	/**
	 * `FbNΏۃt@CԋpB
	 * @param properties ݒl
	 * @return `FbNΏۃt@C
	 */
	public static String[] getIncludes(Properties properties) {
		String value = properties.getProperty(ID_INCLUDE_LIST);
		return CheckBoxListEditComposit.getValidValue(value);
	}

	/**
	 * O`FbNΏۃt@CԋpB
	 * @param properties ݒl
	 * @return O`FbNΏۃt@C
	 */
	public static String[] getExcludes(Properties properties) {
		String value = properties.getProperty(ID_EXCLUDE_LIST);
		return CheckBoxListEditComposit.getValidValue(value);
	}

	/**
	 * `FbNWbNNXԋpB
	 * @param properties ݒl
	 * @return `FbNWbNNX
	 */
	public static String[] getLogicClassNames(Properties properties) {
		String value = properties.getProperty(ID_CHECK_LIST);
		return CheckBoxListEditComposit.getValidValue(value);
	}

	/**
	 * ݒۑB
	 * @param properties ۑݒl
	 */
	private void saveProperties(Properties properties) {
		FileOutputStream out = null;
		try {
			out = new FileOutputStream(getPropertyFile(getProject()));
			properties.store(out, "ResorceChecker Plugin Properties");
		} catch (Throwable t) {
			ResourceCheckerPlugin.log(t);
		} finally {
			try {
				out.flush();
				out.close();
			} catch (IOException e) {
				ResourceCheckerPlugin.log(e);
			}
		}
	}

	/**
	 * w肵vWFNg̐ݒt@CԋpB
	 * @param project vWFNg
	 * @return ݒt@C
	 * @throws CoreException ݒt@C̎擾Ɏsꍇ
	 */
	private static File getPropertyFile(IProject project) throws CoreException {
		return project.getLocation().append(PROPERTIES_FILENAME).toFile();
	}

	/**
	 * vWFNgԋpB
	 * @return vWFNg
	 * @throws CoreException vWFNg̎擾Ɏsꍇ
	 */
	private IProject getProject() throws CoreException {
		return (IProject) (this.getElement().getAdapter(IProject.class));
	}

	/**
	 * vpeBOK{^ꂽƂɐݒۑČʂԋpB
	 * @see org.eclipse.jface.preference.IPreferencePage#performOk()
	 */
	@Override
	public boolean performOk() {
		try {
			Properties p = getProperties(getProject());
			p.setProperty(ID_CHECKER_URI, checkerURIText.getText());
			p.setProperty(ID_INCLUDE_LIST, includeListEditor.getTableValue());
			p.setProperty(ID_EXCLUDE_LIST, excludeListEditor.getTableValue());
			p.setProperty(ID_CHECK_LIST, checkListEditor.getTableValue());
			String checkList = checkListEditor.getTableValue();
			if (enableCheckBox.getSelection()) {
				ToggleNatureAction.addNature(getProject());
				saveProperties(p);
			} else {
				ToggleNatureAction.removeNature(getProject());
				if (getPropertyFile(getProject()).exists()) {
					saveProperties(p);
				} else if ((checkList != null) && (checkList.length() > 0)) {
					saveProperties(p);
				}
			}
		} catch (CoreException e) {
			ResourceCheckerPlugin.log(e);
			return false;
		}
		return true;
	}

}
