/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.action;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import jp.highwide.resourcechecker.ResourceCheckerPlugin;
import jp.highwide.resourcechecker.checker.ResourceCheckerLogic;
import jp.highwide.resourcechecker.checker.ResourceCheckerMarker;
import jp.highwide.resourcechecker.checker.ResourceCheckerResult;
import jp.highwide.resourcechecker.checker.StringWithLineNumber;
import jp.highwide.resourcechecker.property.ResourceCheckerPage;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.MarkerUtilities;

/**
 * pbP[WEGNXv[[őI\[X̃`FbNsActionNXB<br>
 * \[X̃`FbNɎgp郍WbN<code>ResourceCheckerLogic</code>NX
 * @see ResourceCheckerLogic
 */
public class ResourceCheckerAction implements IEditorActionDelegate {
	private ISelection selection;

	/**
	 * RXgN^B<br>
	 * ȂB
	 */
	public ResourceCheckerAction() {
	}

	/**
	 * ȂB
	 * @see org.eclipse.ui.IEditorActionDelegate#setActiveEditor(org.eclipse.jface.action.IAction, org.eclipse.ui.IEditorPart)
	 */
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
	}

	/**
	 * <code>run</code>ŎgpselectionێB
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

	/**
	 * \[X̃`FbNsB<br>
	 * Ώۂ͑Iꂽ\[X
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		if (!(selection instanceof IStructuredSelection)) {
			return;
		}
		// Iꂽ\[X̔o
		IStructuredSelection structuredSelection = (IStructuredSelection) selection;
		IProject project = null;
		List<IResource> resources = new ArrayList<IResource>();
		for (Iterator it = structuredSelection.iterator(); it.hasNext();) {
			Object element = it.next();
			if (element instanceof IResource) {
				IResource resource = (IResource) element;
				// TODO ΉvWFNg1
				if (project == null) {
					project = resource.getProject();
				}
				resources.add(resource);
			}
		}
		if (project == null) {
			// \[XProjectȂꍇ͉Ȃ
			return;
		}

		try {
			// ݒl擾
			Properties properties = ResourceCheckerPage.getProperties(project);
			String[] includes = ResourceCheckerPage.getIncludes(properties);
			String[] excludes = ResourceCheckerPage.getExcludes(properties);
			String[] checks = ResourceCheckerPage.getLogicClassNames(properties);
			String checkerURI = ResourceCheckerPage.getLogicURI(properties);
			List<ResourceCheckerLogic> checkLogicList = ResourceCheckerAction.getLogic(checkerURI,
					checks);

			// `FbN郊\[XtB^
			ArrayList<IFile> fileList = new ArrayList<IFile>();
			for (IResource resource : resources) {
				fileList.addAll(getFiles(resource, includes, excludes));
			}

			// \[X`FbN
			CheckRunnableWithProgress runProgress = new CheckRunnableWithProgress(fileList,
					checkLogicList,
					this);
			// ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(new Shell());
			// progressMonitorDialog.run(true, true, runProgress);
			// TODO obNOEhŎs͕s
			IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
						progressService.busyCursorWhile(runProgress);

			checkLogicList.clear();
			checkLogicList = null;
			System.gc();

		} catch (CoreException e) {
			ResourceCheckerPlugin.log(e);
		} catch (Exception e) {
			ResourceCheckerPlugin.log(e);
		}
	}

	/**
	 * \[X`FbNvOXtŎsB
	 */
	private class CheckRunnableWithProgress implements IRunnableWithProgress {
		private ArrayList<IFile> fileList;
		private List<ResourceCheckerLogic> checkLogicList;
		private ResourceCheckerAction checker;

		/**
		 * RXgN^B
		 * @param fileList `FbNΏۂ̃t@C̃Xg
		 * @param checkLogicList `FbNWbÑXg
		 * @param checker ResourceCheckerAction
		 */
		public CheckRunnableWithProgress(ArrayList<IFile> fileList,
				List<ResourceCheckerLogic> checkLogicList,
				ResourceCheckerAction checker) {
			this.fileList = fileList;
			this.checkLogicList = checkLogicList;
			this.checker = checker;
		}

		/**
		 * \[X`FbNvOXtŎsB
		 * @see org.eclipse.jface.operation.IRunnableWithProgress#run(org.eclipse.core.runtime.IProgressMonitor)
		 */
		public void run(IProgressMonitor monitor) throws InvocationTargetException,
				InterruptedException {
			try {
				int total = fileList.size();
				int count = 1;
				monitor.beginTask("\[X`FbNn߂܂B", total);
				for (IFile ifile : fileList) {
					monitor.subTask("`FbN " + count + "/" + total + " ="
							+ ifile);
					// \[X`FbN
					checker.check(ifile, checkLogicList);
					count++;
					monitor.worked(1);
					if (monitor.isCanceled()) {
						// throw new InterruptedException("LZ܂B");
						break;
					}
				}
			} finally {
				checkLogicList = null;
				monitor.done();
			}
		}
	}

	/**
	 * w肳ꂽPꃊ\[X`FbNsB<br>
	 * \[X`FbN͎w肳ꂽ`FbNWbNSĂKpB<br>
	 * @param iFile `FbNst@C
	 * @param checkLogicList `FbNWbÑXg
	 */
	public void check(IFile iFile, List<ResourceCheckerLogic> checkLogicList) {
		// `FbNp[^
		File absoluteFile = iFile.getLocation().toFile();
		List<StringWithLineNumber> source;
		try {
			source = getSource(iFile);
		} catch (CoreException e) {
			ResourceCheckerPlugin.log(e);
			return;
		} catch (IOException e) {
			ResourceCheckerPlugin.log(e);
			return;
		}

		ArrayList<ResourceCheckerMarker> markerList = new ArrayList<ResourceCheckerMarker>();
		for (ResourceCheckerLogic logic : checkLogicList) {
			try {
				logic.doCheck(absoluteFile, iFile.getFileExtension(), source);
				// TODO Java̍\͂sʂI/FɎ`FbNWbN쐬\
				//				ICompilationUnit iCompilationUnit = (ICompilationUnit) iFile.getAdapter(IJavaElement.class);
				//				if (iCompilationUnit != null) {
				//					// Javat@C̏ꍇ
				//					String packageName = getPackageName(iCompilationUnit);
				//					String className = getClassName(iCompilationUnit);
				//
				//					ClassLoader l = Thread.currentThread().getContextClassLoader();
				//					l.loadClass("jp.highwide.resourcechecker.checker.StringWithLineNumber");
				//
				//					logic.doCheckJavaFile(absoluteFile,
				//							source,
				//							packageName,
				//							className);
				//				} else {
				//					// Javat@CȊO
				//					logic.doCheck(absoluteFile, source);
				//				}
			} catch (Throwable e) {
				ResourceCheckerPlugin.log(new Exception("`FbNWbNŗO܂B",
						e));
			}

			// `FbNWbŇʂ}[J[ɕϊ
			List<ResourceCheckerResult> logicResultList = logic.getResult();
			for (ResourceCheckerResult logicResult : logicResultList) {
				ResourceCheckerMarker marker = new ResourceCheckerMarker(logicResult);
				markerList.add(marker);
			}
			logic.clearResult();
		}

		// }[J[쐬
		for (ResourceCheckerMarker marker : markerList) {
			try {
				Map<String, Object> attributes = marker.getAttributes();
				MarkerUtilities.createMarker(iFile,
						attributes,
						ResourceCheckerMarker.MARKER_ID);
			} catch (CoreException e) {
				ResourceCheckerPlugin.log(e);
			}
		}
	}

	//	/**
	//	 * pbP[W擾B
	//	 * @param iCompilationUnit ICompilationUnit
	//	 * @return pbP[WBftHg̏ꍇ͋󔒕
	//	 * @throws JavaModelException pbP[W̎擾Ɏsꍇ
	//	 */
	//	private String getPackageName(ICompilationUnit iCompilationUnit)
	//			throws JavaModelException {
	//		String result = null;
	//		IPackageDeclaration[] packageDeclarations = iCompilationUnit.getPackageDeclarations();
	//		if (packageDeclarations.length == 0) {
	//			result = "";
	//		} else {
	//			result = packageDeclarations[0].getElementName();
	//		}
	//		return result;
	//	}
	//	/**
	//	 * NX擾B
	//	 * @param iCompilationUnit ICompilationUnit
	//	 * @return NX
	//	 * @throws JavaModelException 擾Ɏsꍇ
	//	 */
	//	private String getClassName(ICompilationUnit iCompilationUnit)
	//			throws JavaModelException {
	//		String result = null;
	//		IType type = iCompilationUnit.getAllTypes()[0];
	//		result = type.getElementName();
	//		return result;
	//	}
	/**
	 * w肳ꂽt@C̃\[XList&lt;StringWithLineNumber&gt;`ɂĎ擾B
	 * @param file 擾Ώۂ̃t@C
	 * @return List&lt;StringWithLineNumber&gt;`̃\[X
	 * @throws CoreException t@Ccharset擾Ɏsꍇ
	 * @throws IOException t@C̓ǂݍ݂Ɏsꍇ
	 */
	private List<StringWithLineNumber> getSource(IFile file) throws CoreException,
			IOException {
		ArrayList<StringWithLineNumber> result = new ArrayList<StringWithLineNumber>();
		InputStream inputStream = null;
		InputStreamReader inputStreamReader = null;
		try {
			inputStream = file.getContents();
			inputStreamReader = new InputStreamReader(inputStream,
					file.getCharset());
			StringBuilder lineBuffer = new StringBuilder();
			int c = -1;
			int lineNumber = 0;
			int offset = 0;
			while ((c = inputStreamReader.read()) != -1) {
				if (c == '\n') {
					lineBuffer.append((char) c);
					lineNumber++;
					StringWithLineNumber line = new StringWithLineNumber(lineBuffer.toString(),
							lineNumber,
							offset);
					result.add(line);
					offset += lineBuffer.toString().length();
					lineBuffer = new StringBuilder();
					continue;
				}
				lineBuffer.append((char) c);
			}
			if (lineBuffer.length() > 0) {
				StringWithLineNumber line = new StringWithLineNumber(lineBuffer.toString(),
						++lineNumber,
						offset);
				result.add(line);
			}
		} finally {
			if (inputStreamReader != null) {
				try {
					inputStreamReader.close();
				} catch (IOException e) {
				}
			}
			if (inputStream != null) {
				try {
					inputStream.close();
				} catch (IOException e) {
				}
			}
		}
		return result;
	}

	/**
	 * w肳ꂽURI`FbNWbNjar擾AResourceCheckerLogic̃Xg擾B
	 * @param checkerURI ResourceCheckerLogic܂jarURI
	 * @param checkLogicClassNames s`FbNWbÑNX
	 * @return ResourceCheckerLogic̃Xg
	 * @throws URISyntaxException `FbNWbNjarURIsȏꍇ
	 * @throws MalformedURLException `FbNWbNjarURLsȏꍇ
	 */
	public static List<ResourceCheckerLogic> getLogic(String checkerURI,
			String[] checkLogicClassNames) throws URISyntaxException,
			MalformedURLException {
		// `FbNWbN擾
		URI uri = new URI(checkerURI);
		URL url = uri.toURL();
		// TODO URLClassLoaderVMċNȂƓǂݍURL̃NXւȂHAfile://̂̂OK
		// ClassLoader parent = Thread.currentThread().getContextClassLoader();
		CacheURLClassLoader loader = new CacheURLClassLoader(new URL[] { url });
		// eclipsẽNX[_[(ContextFinder)eɂURLClassLoader쐬Ă
		// e{vOC̃NX邱Ƃ͂łȂB
		// Ȃ̂ŁAeɂŃNXo^ĂB
		loader.addCacheClass(StringWithLineNumber.class);
		loader.addCacheClass(ResourceCheckerLogic.class);
		loader.addCacheClass(ResourceCheckerResult.class);

		ArrayList<ResourceCheckerLogic> checkLogicList = new ArrayList<ResourceCheckerLogic>();
		for (String checkLogicClassName : checkLogicClassNames) {
			try {
				Class c = loader.loadClass(checkLogicClassName);
				Constructor constructor = c.getConstructor(new Class[] {});
				Object checkObject = constructor.newInstance(new Object[] {});
				if (checkObject instanceof ResourceCheckerLogic) {
					checkLogicList.add((ResourceCheckerLogic) checkObject);
				}
			} catch (Exception e) {
				ResourceCheckerPlugin.log(e);
			}
		}
		return checkLogicList;
	}

	/**
	 * {NX̃[hURLpXԋpB
	 * jaȑꍇjarURL ex. jar:file:/C:/jp.highwide.resourcechecker_1.0.0.jar!/
	 * @return {NX̃[hURL
	 * @throws IOException 
	 */
	protected static URL getResourceCheckerURL() throws IOException {
		String ownPackage = ResourceCheckerAction.class.getPackage().getName();
		ownPackage = ownPackage.replace('.', '/');
		ownPackage = "/" + ownPackage;
		URL ownURL = ResourceCheckerAction.class.getResource(ownPackage);
		URL result = null;
		try {
			result = new URL(ownURL.toString().replaceFirst(ownPackage + "$",
					""));
			result = Platform.resolve(result);
		} catch (IOException e) {
			IOException ex = new IOException("ResourceCheckervOCURL擾ł܂łB");
			ex.initCause(e);
			throw ex;
		}
		return result;
	}

	/**
	 * \[XɃtB^ă`FbNΏۂ̃t@CԋpB
	 * @param child \[X
	 * @param includes `FbNΏ
	 * @param excludes O`FbNΏ
	 * @return `FbNΏۂ̃t@C
	 * @throws CoreException `FbNΏۂ̎擾Ɏsꍇ
	 */
	public static List<IFile> getFiles(IResource child,
			String[] includes,
			String[] excludes) throws CoreException {
		List<IFile> resourceList = new ArrayList<IFile>();
		child.deleteMarkers(ResourceCheckerMarker.MARKER_ID,
				false,
				IResource.DEPTH_INFINITE);
		if (child instanceof IFile) {
			if (isValidFile((IFile) child, includes, excludes)) {
				resourceList.add((IFile) child);
			}
		} else if (child instanceof IContainer) {
			resourceList.addAll(getFiles((IContainer) child, includes, excludes));
		}
		return resourceList;
	}

	/**
	 * \[XɃtB^ă`FbNΏۂ̃t@CԋpB
	 * @param delta \[X
	 * @param includes `FbNΏ
	 * @param excludes O`FbNΏ
	 * @return `FbNΏۂ̃t@C
	 * @throws CoreException `FbNΏۂ̎擾Ɏsꍇ
	 */
	public static List<IFile> getFiles(IResourceDelta delta,
			String[] includes,
			String[] excludes) throws CoreException {
		List<IFile> resources = new ArrayList<IFile>();
		IResourceDelta[] affectedChildren = delta.getAffectedChildren();
		for (int i = 0; i < affectedChildren.length; i++) {
			IResourceDelta childDelta = affectedChildren[i];
			int deltaKind = childDelta.getKind();
			if ((deltaKind == IResourceDelta.ADDED)
					|| (deltaKind == IResourceDelta.CHANGED)) {
				IResource child = childDelta.getResource();
				if (child instanceof IFile) {
					child.deleteMarkers(ResourceCheckerMarker.MARKER_ID,
							false,
							IResource.DEPTH_INFINITE);
					if (isValidFile((IFile) child, includes, excludes)) {
						resources.add((IFile) child);
					}
				} else if (child instanceof IContainer) {
					resources.addAll(getFiles(childDelta, includes, excludes));
				}
			}
		}
		return resources;
	}

	/**
	 * \[XɃtB^ă`FbNΏۂ̃t@CԋpB
	 * @param container \[X
	 * @param includes `FbNΏ
	 * @param excludes O`FbNΏ
	 * @return `FbNΏۂ̃t@C
	 * @throws CoreException `FbNΏۂ̎擾Ɏsꍇ
	 */
	private static List<IFile> getFiles(IContainer container,
			String[] includes,
			String[] excludes) throws CoreException {
		List<IFile> resources = new ArrayList<IFile>();
		IResource[] children = container.members();
		for (int i = 0; i < children.length; i++) {
			IResource child = children[i];
			if (child instanceof IFile
					&& isValidFile((IFile) child, includes, excludes)) {
				child.deleteMarkers(ResourceCheckerMarker.MARKER_ID,
						false,
						IResource.DEPTH_INFINITE);
				resources.add((IFile) child);
			} else if (child instanceof IContainer) {
				resources.addAll(getFiles((IContainer) child,
						includes,
						excludes));
			}
		}
		return resources;
	}

	/**
	 * tB^Ώۂ`FbNB
	 * @param iFile `FbNΏ
	 * @param includes `FbNΏ
	 * @param excludes O`FbNΏ
	 * @return `FbNΏۂ̏ꍇtrue
	 */
	private static boolean isValidFile(IFile iFile,
			String[] includes,
			String[] excludes) {
		String fileName = iFile.getName();
		String fileExtension = iFile.getFileExtension();

		if (isValidExtension(fileName, fileExtension)) {
			String filePath = iFile.getFullPath().toString();
			for (int i = 0; i < includes.length; i++) {
				if (filePath.matches(includes[i])) {
					return true;
				}
			}
			for (int i = 0; i < excludes.length; i++) {
				if (filePath.matches(excludes[i])) {
					return false;
				}
			}
			return true;
		} else {
			return false;
		}
	}

	/**
	 * `FbNΏۂ̊gqLǂB<br>
	 * jart@CAclasst@CA.Ŏn܂t@C̓`FbNΏۊOB
	 * @param fileName `FbNΏۂ̃t@C
	 * @param fileExtension `FbNΏۂ̊gq
	 * @return L̏ꍇtrue
	 */
	private static boolean isValidExtension(String fileName,
			String fileExtension) {

		if (fileExtension == null) {
			return true;
		}
		if (fileExtension.equals("jar")) {
			return false;
		} else if (fileExtension.equals("class")) {
			return false;
		} else if (fileName.startsWith(".")) {
			return false;
		}
		return true;
	}

}
