/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.checker;

/**
 * t@C1s̓eƁAsԍAItZbgi[NXB
 */
public class StringWithLineNumber {
	private String string;
	private int lineNumber;
	private int offset;

	/**
	 * RXgN^B
	 * @param string \[X1s̓e
	 * @param lineNumber sԍ
	 * @param offset ItZbg
	 */
	public StringWithLineNumber(String string, int lineNumber, int offset) {
		this.string = string;
		this.lineNumber = lineNumber;
		this.offset = offset;
	}

	/**
	 * sԍԋpB<p>
	 * t@Cɂ邱̃NXŊi[s̔ԍԋpB
	 * ȂsԍEclipse̍sԍƓ1n܂B
	 * @return sԍ
	 */
	public int getLineNumber() {
		return lineNumber;
	}

	/**
	 * ItZbgԋpB<p>
	 * t@C̐擪̕琔āA
	 * ̃NXŊi[̍ŏ̕܂ł̕ԋpB
	 * 擪s(1s)̏ꍇAԋpItZbg0ƂȂB
	 * @return ItZbg
	 */
	public int getOffset() {
		return offset;
	}

	/**
	 * t@C1s̓eԋpB<p>
	 * t@Cɂ{@link #getLineNumber()}Ŏꂽs̕ԋpB<br>
	 * s̉sR[h(CR,LF)܂ނߒӂ邱ƁB<br>
	 * Ȃ݂ɁA{@link #toString()}\bhƓ̓eԋpB
	 * @return t@C1s̓e
	 * @see #toString()
	 */
	public String getString() {
		return string;
	}

	/**
	 * t@C1s̓eԋpB<p>
	 * t@Cɂ{@link #getLineNumber()}Ŏꂽs̕ԋpB<br>
	 * s̉sR[h(CR,LF)܂ނߒӂ邱ƁB
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return string;
	}

	/**
	 * IuWFNg̃nbVlԋpB
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + lineNumber;
		result = PRIME * result + ((string == null) ? 0 : string.hashCode());
		return result;
	}

	/**
	 * IuWFNg̔rsB<p>
	 * rΏۂ{@link #getString()}̂݁̕B
	 * AA{@link java.lang.String}ƔrĂv͂Ȃ̂ŒӁB 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final StringWithLineNumber other = (StringWithLineNumber) obj;
		if (string == null) {
			if (other.string != null)
				return false;
		} else if (!string.equals(other.string))
			return false;
		return true;
	}

}
