/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.builder;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import jp.highwide.resourcechecker.ResourceCheckerPlugin;
import jp.highwide.resourcechecker.action.ResourceCheckerAction;
import jp.highwide.resourcechecker.checker.ResourceCheckerLogic;
import jp.highwide.resourcechecker.property.ResourceCheckerPage;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * \[X`FbJ[̃r_[NXB
 */
public class ResourceCheckerBuilder extends IncrementalProjectBuilder {
	/** r_[ID */
	public static final String BUILDER_ID = "jp.highwide.resourcechecker.resourceCheckerBuilder";

	/**
	 * rh̃\[X`FbNsB
	 * @see org.eclipse.core.resources.IncrementalProjectBuilder#build(int, java.util.Map, org.eclipse.core.runtime.IProgressMonitor)
	 */
	@Override
	protected IProject[] build(int kind, Map args, IProgressMonitor monitor)
			throws CoreException {

		IProject project = getProject();
		try {
			// ݒl擾
			Properties properties = ResourceCheckerPage.getProperties(project);
			String[] includes = ResourceCheckerPage.getIncludes(properties);
			String[] excludes = ResourceCheckerPage.getExcludes(properties);
			String[] checks = ResourceCheckerPage.getLogicClassNames(properties);
			String checkerURI = ResourceCheckerPage.getLogicURI(properties);
			List<ResourceCheckerLogic> checkLogicList = ResourceCheckerAction.getLogic(checkerURI,
					checks);

			List<IFile> fileList;
			IResourceDelta delta = getDelta(getProject());

			if (kind == FULL_BUILD || delta == null) {
				fileList = ResourceCheckerAction.getFiles(project,
						includes,
						excludes);
			} else {
				fileList = ResourceCheckerAction.getFiles(delta,
						includes,
						excludes);
			}

			int total = fileList.size();
			int count = 1;
			ResourceCheckerAction checker = new ResourceCheckerAction();
			monitor.beginTask("\[X`FbNn߂܂B", total);
			for (IFile ifile : fileList) {
				monitor.subTask("`FbN " + count + "/" + total + " =" + ifile);
				checker.check(ifile, checkLogicList);
				count++;
				monitor.worked(1);
			}
		} catch (CoreException e) {
			ResourceCheckerPlugin.log(e);
		} catch (MalformedURLException e) {
			ResourceCheckerPlugin.log(e);
		} catch (URISyntaxException e) {
			ResourceCheckerPlugin.log(e);
		} finally {
			monitor.done();
		}

		return null;
	}
}
