/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.checker;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import jp.highwide.resourcechecker.checker.ResourceCheckerResult.Severity;

/**
 * `FbNWbNŌp钊ۃNXB
 * ResourceCheckerLogicpNXɑ΂ă`FbNsB<br>
 * |bvAbvj[́u\[X`FbJ[svA
 * ́At@C̕ۑ(ݒ̎`FbNON̏ꍇ)<code>doCheck</code>\bhĂ΂B<br>
 * <code>doCheck</code>Ń`FbNA
 * <code>addError</code>\bhE<code>addWarning</code>\bhE<code>addInfo</code>\bh
 * gpă}[J[쐬B
 */
public abstract class ResourceCheckerLogic {
	/** `FbNʊi[ */
	private List<ResourceCheckerResult> resultList = new ArrayList<ResourceCheckerResult>();

	/**
	 * RXgN^B<br>
	 * Ȃ̃RXgN^KvB
	 */
	public ResourceCheckerLogic() {
	}
	/**
	 * `FbNWbN̖OԋpB<br>
	 * O͏dĂ̓_B
	 * @return O
	 */
	public abstract String getName();

	/**
	 * Eclipsẽ\[X(xxx.java)̃`FbNWbNB
	 * @param file `FbNΏۂ̃t@C
	 * @param fileExtension `FbNΏۂ̃t@C̊gq(ex. java)
	 * @param source `FbNΏۂ̃t@C1sɊi[List
	 * @throws Exception `FbNɎsꍇ<br>
	 * throwOeclipsẽOɏo͂BuG[EOvr[ŊmF\
	 */
	public abstract void doCheck(File file,
			String fileExtension,
			List<StringWithLineNumber> source) throws Exception;

	/**
	 * G[x̌ʂǉB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 */
	public void addError(String message, int lineNumber) {
		addCheckResult(message,
				lineNumber,
				Severity.SEVERITY_ERROR,
				-1,
				-1,
				null);
	}
	/**
	 * G[x̌ʂǉB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 * @param start Jnʒu
	 * @param end Iʒu
	 */
	public void addError(String message, int lineNumber, int start, int end) {
		addCheckResult(message,
				lineNumber,
				Severity.SEVERITY_ERROR,
				start,
				end,
				null);
	}
	/**
	 * G[x̌ʂǉB<br>
	 * ʓrEclipsẽNCbNtBbNXvOC쐬ꍇɎgpB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 * @param start Jnʒu
	 * @param end Iʒu
	 * @param userData Cӂ̃f[^(Resolution̂߂̊g)
	 */
	public void addError(String message,
			int lineNumber,
			int start,
			int end,
			Object userData) {
		addCheckResult(message,
				lineNumber,
				Severity.SEVERITY_ERROR,
				start,
				end,
				userData);
	}

	/**
	 * xx̌ʂǉB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 */
	public void addWarning(String message, int lineNumber) {
		addCheckResult(message,
				lineNumber,
				Severity.SEVERITY_WARNING,
				-1,
				-1,
				null);
	}
	/**
	 * xx̌ʂǉB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 * @param start Jnʒu
	 * @param end Iʒu
	 */
	public void addWarning(String message, int lineNumber, int start, int end) {
		addCheckResult(message,
				lineNumber,
				Severity.SEVERITY_WARNING,
				start,
				end,
				null);
	}

	/**
	 * xx̌ʂǉB<br>
	 * ʓrEclipsẽNCbNtBbNXvOC쐬ꍇɎgpB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 * @param start Jnʒu
	 * @param end Iʒu
	 * @param userData Cӂ̃f[^(Resolution̂߂̊g)
	 */
	public void addWarning(String message,
			int lineNumber,
			int start,
			int end,
			Object userData) {
		addCheckResult(message,
				lineNumber,
				Severity.SEVERITY_WARNING,
				start,
				end,
				userData);
	}

	/**
	 * 񃌃x̌ʂǉB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 */
	public void addInfo(String message, int lineNumber) {
		addCheckResult(message,
				lineNumber,
				Severity.SEVERITY_INFO,
				-1,
				-1,
				null);
	}
	/**
	 * 񃌃x̌ʂǉB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 * @param start Jnʒu
	 * @param end Iʒu
	 */
	public void addInfo(String message, int lineNumber, int start, int end) {
		addCheckResult(message,
				lineNumber,
				Severity.SEVERITY_INFO,
				start,
				end,
				null);
	}
	/**
	 * 񃌃x̌ʂǉB<br>
	 * ʓrEclipsẽNCbNtBbNXvOC쐬ꍇɎgpB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 * @param start Jnʒu
	 * @param end Iʒu
	 * @param userData Cӂ̃f[^(Resolution̂߂̊g)
	 */
	public void addInfo(String message,
			int lineNumber,
			int start,
			int end,
			Object userData) {
		addCheckResult(message,
				lineNumber,
				Severity.SEVERITY_INFO,
				start,
				end,
				userData);
	}

	/**
	 * ʂǉB
	 * @param message bZ[W
	 * @param lineNumber sԍ
	 * @param severity dvx
	 * @param start Jnʒu
	 * @param end Iʒu
	 * @param userData Cӂ̃f[^(Resolution̂߂̊g)
	 */
	private void addCheckResult(String message,
			int lineNumber,
			Severity severity,
			int start,
			int end,
			Object userData) {
		ResourceCheckerResult result = new ResourceCheckerResult();
		result.setLogicName(getName());
		result.setSeverity(severity);
		result.setMessage(message);
		result.setLineNumber(lineNumber);
		result.setCharStart(start);
		result.setCharEnd(end);
		result.setUserData(userData);
		resultList.add(result);
	}

	/**
	 * `FbNʂԋpB
	 * @return `FbN
	 */
	public List<ResourceCheckerResult> getResult() {
		return resultList;
	}
	/**
	 * `FbNʂNAB
	 */
	public void clearResult() {
		resultList.clear();
	}
}
