/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.transactionservice;

import io.remme.java.api.NetworkConfig;
import io.remme.java.enums.Patterns;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.websocket.RemmeWebSocket;
import io.remme.java.websocket.dto.RemmeRequestParams;
import io.remme.java.websocket.enums.RemmeEvents;

public class BaseTransactionResponse
extends RemmeWebSocket {
    private String batchId;

    public BaseTransactionResponse(String nodeAddress, boolean sslMode, String batchId) {
        super(nodeAddress, sslMode, new RemmeRequestParams(RemmeEvents.BATCH, batchId, null, null));
        this.setBatchId(batchId);
    }

    public BaseTransactionResponse(NetworkConfig networkConfig, String batchId) {
        super(networkConfig, new RemmeRequestParams(RemmeEvents.BATCH, batchId, null, null));
        this.setBatchId(batchId);
    }

    public void setBatchId(String value) {
        if (!value.matches(Patterns.HEADER_SIGNATURE.getPattern())) {
            throw new RemmeValidationException("Given batch id is invalid");
        }
        if (this.client != null && this.client.isOpen()) {
            super.closeWebSocket();
        }
        this.batchId = value;
        this.data.setId(value);
    }

    public String getBatchId() {
        return this.batchId;
    }
}

