/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.token;

import io.remme.java.api.IRemmeApi;
import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.enums.RemmeMethod;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.protobuf.AccountOuterClass;
import io.remme.java.protobuf.Transaction;
import io.remme.java.token.IRemmeToken;
import io.remme.java.transactionservice.BaseTransactionResponse;
import io.remme.java.transactionservice.IRemmeTransactionService;
import io.remme.java.transactionservice.dto.CreateTransactionDto;
import io.remme.java.utils.Functions;
import io.remme.java.utils.models.PublicKeyRequest;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class RemmeToken
implements IRemmeToken {
    private IRemmeApi remmeApi;
    private IRemmeTransactionService remmeTransaction;
    private RemmeFamilyName familyName = RemmeFamilyName.ACCOUNT;
    private String familyVersion = "0.1";

    public RemmeToken(IRemmeApi remmeApi, IRemmeTransactionService remmeTransaction) {
        this.remmeApi = remmeApi;
        this.remmeTransaction = remmeTransaction;
    }

    @Override
    public Future<BaseTransactionResponse> transfer(String addressTo, Long amount) {
        try {
            Functions.checkAddress(addressTo);
            if (amount == null) {
                throw new RemmeValidationException("Amount was not provided, please set the amount");
            }
            if (amount <= 0L) {
                throw new RemmeValidationException("Amount must be higher than 0");
            }
            AccountOuterClass.TransferPayload transferPayload = AccountOuterClass.TransferPayload.newBuilder().setAddressTo(addressTo).setValue(amount).build();
            Transaction.TransactionPayload transactionPayload = Transaction.TransactionPayload.newBuilder().setMethod(AccountOuterClass.AccountMethod.Method.TRANSFER.getNumber()).setData(transferPayload.toByteString()).build();
            CreateTransactionDto dto = CreateTransactionDto.builder().familyName(this.familyName.getName()).familyVersion(this.familyVersion).inputs(new String[]{addressTo}).outputs(new String[]{addressTo}).payloadBytes(transactionPayload.toByteArray()).build();
            Future<String> transaction = this.remmeTransaction.create(dto);
            return this.remmeTransaction.send(transaction.get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<Long> getBalance(String address) {
        Functions.checkAddress(address);
        return this.remmeApi.sendRequest(RemmeMethod.TOKEN, new PublicKeyRequest(address), Long.class);
    }

    public String getFamilyVersion() {
        return this.familyVersion;
    }

    public void setFamilyVersion(String familyVersion) {
        this.familyVersion = familyVersion;
    }
}

