/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.keys.dto;

import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.error.RemmeKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyDTO {
    protected String address;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected String privateKeyHex;
    protected String publicKeyHex;
    protected String publicKeyPem;
    protected String privateKeyPem;
    protected String publicKeyBase64;
    protected String keyType;
    protected RemmeFamilyName familyName = RemmeFamilyName.PUBLIC_KEY;

    public PrivateKey getPrivateKey() {
        if (this.privateKey == null) {
            throw new RemmeKeyException("You didn't provide private key");
        }
        return this.privateKey;
    }

    public String getPrivateKeyPem() {
        if (this.privateKeyPem == null) {
            throw new RemmeKeyException("Don't supported for this key type: " + this.keyType + " or didn't provide private key");
        }
        return this.privateKeyPem;
    }

    public String getPublicKeyPem() {
        if (this.publicKeyPem == null) {
            throw new RemmeKeyException("Don't supported for this key type: " + this.keyType);
        }
        return this.publicKeyPem;
    }

    public String getPrivateKeyHex() {
        if (this.privateKeyHex == null) {
            throw new RemmeKeyException("Don't supported for this key type: " + this.keyType + " or didn't provide private key");
        }
        return this.privateKeyHex;
    }

    public String getPublicKeyHex() {
        if (this.publicKeyHex == null) {
            throw new RemmeKeyException("Don't supported for this key type: " + this.keyType);
        }
        return this.publicKeyHex;
    }

    public String getAddress() {
        return this.address;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getPublicKeyBase64() {
        return this.publicKeyBase64;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public RemmeFamilyName getFamilyName() {
        return this.familyName;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

