/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.keys;

import io.remme.java.enums.KeyType;
import io.remme.java.error.RemmeKeyException;
import io.remme.java.keys.ECDSA;
import io.remme.java.keys.EDDSA;
import io.remme.java.keys.IRemmeKeys;
import io.remme.java.keys.RSA;
import io.remme.java.keys.dto.GenerateOptions;
import io.remme.java.utils.RemmeExecutorService;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class RemmeKeys {
    public static Future<KeyPair> generateKeyPair(KeyType keyType, GenerateOptions options) {
        ExecutorService es = RemmeExecutorService.getInstance();
        switch (keyType) {
            case RSA: {
                return es.submit(() -> RSA.generateKeyPair(options));
            }
            case EdDSA: {
                return es.submit(() -> EDDSA.generateKeyPair(options));
            }
            case ECDSA: {
                return es.submit(ECDSA::generateKeyPair);
            }
        }
        throw new RemmeKeyException("Unsupported keyType: " + keyType.name());
    }

    public static String getAddressFromPublicKey(KeyType keyType, PublicKey publicKey) {
        switch (keyType) {
            case RSA: {
                return RSA.getAddressFromPublicKey(publicKey);
            }
            case EdDSA: {
                return EDDSA.getAddressFromPublicKey(publicKey);
            }
            case ECDSA: {
                return ECDSA.getAddressFromPublicKey(publicKey);
            }
        }
        throw new RemmeKeyException("Unsupported keyType: " + keyType.name());
    }

    public static IRemmeKeys construct(KeyType keyType, PublicKey publicKey, PrivateKey privateKey) {
        try {
            KeyType keyType2 = keyType = keyType != null ? keyType : KeyType.RSA;
            if (privateKey == null && publicKey == null) {
                KeyPair keyPair = RemmeKeys.generateKeyPair(keyType, null).get();
                privateKey = keyPair.getPrivate();
                publicKey = keyPair.getPublic();
            }
            switch (keyType) {
                case RSA: {
                    return new RSA(publicKey, privateKey);
                }
                case EdDSA: {
                    return new EDDSA(privateKey, publicKey);
                }
                case ECDSA: {
                    return new ECDSA(privateKey, publicKey);
                }
            }
            throw new RemmeKeyException("Unsupported keyType: " + keyType.name());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RemmeKeyException(e);
        }
    }
}

