/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.keys;

import io.remme.java.enums.KeyType;
import io.remme.java.enums.RSASignaturePadding;
import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.error.RemmeKeyException;
import io.remme.java.keys.IRemmeKeys;
import io.remme.java.keys.dto.GenerateOptions;
import io.remme.java.keys.dto.KeyDTO;
import io.remme.java.utils.Functions;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.EdDSASecurityProvider;
import net.i2p.crypto.eddsa.spec.EdDSAGenParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.util.Asserts;

public class EDDSA
extends KeyDTO
implements IRemmeKeys {
    public EDDSA(PrivateKey privateKey, PublicKey publicKey) {
        if (privateKey != null && publicKey != null) {
            Asserts.check((boolean)(privateKey instanceof EdDSAPrivateKey), (String)"Private Key should be instance of EdDSAPrivateKey");
            Asserts.check((boolean)(publicKey instanceof EdDSAPublicKey), (String)"Public Key should be instance of EdDSAPublicKey");
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        } else if (privateKey != null) {
            Asserts.check((boolean)(privateKey instanceof EdDSAPrivateKey), (String)"Private Key should be instance of EdDSAPrivateKey");
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");
            this.privateKey = privateKey;
            this.publicKey = new EdDSAPublicKey(new EdDSAPublicKeySpec(((EdDSAPrivateKey)this.privateKey).getA(), (EdDSAParameterSpec)spec));
        } else if (publicKey != null) {
            Asserts.check((boolean)(publicKey instanceof EdDSAPublicKey), (String)"Public Key should be instance of EdDSAPublicKey");
            this.publicKey = publicKey;
        }
        this.publicKeyHex = Hex.encodeHexString((byte[])this.publicKey.getEncoded());
        if (privateKey != null) {
            this.privateKeyHex = Hex.encodeHexString((byte[])this.privateKey.getEncoded());
        }
        this.publicKeyBase64 = Base64.encodeBase64String((byte[])this.publicKeyHex.getBytes(StandardCharsets.UTF_8));
        this.address = Functions.generateAddress(this.familyName.getName(), this.publicKeyHex);
        this.keyType = KeyType.EdDSA.getType();
    }

    public static String getAddressFromPublicKey(PublicKey publicKey) {
        Asserts.check((boolean)(publicKey instanceof EdDSAPublicKey), (String)"Public Key should be instance of EdDSAPublicKey");
        return Functions.generateAddress(RemmeFamilyName.PUBLIC_KEY.getName(), Hex.encodeHexString((byte[])publicKey.getEncoded()));
    }

    public static KeyPair generateKeyPair(GenerateOptions options) {
        if (options != null && options.getSeed() != null) {
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");
            EdDSAPrivateKeySpec privKey = new EdDSAPrivateKeySpec(options.getSeed(), (EdDSAParameterSpec)spec);
            EdDSAPublicKeySpec pubKey = new EdDSAPublicKeySpec(privKey.getA(), (EdDSAParameterSpec)spec);
            return new KeyPair((PublicKey)new EdDSAPublicKey(pubKey), (PrivateKey)new EdDSAPrivateKey(privKey));
        }
        return EDDSA.generateKeyPair();
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("EdDSA", (Provider)new EdDSASecurityProvider());
            generator.initialize((AlgorithmParameterSpec)new EdDSAGenParameterSpec("Ed25519"));
            return generator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String sign(byte[] data) {
        try {
            if (this.privateKey == null) {
                throw new RemmeKeyException("PrivateKey is not provided!");
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            Signature signature = Signature.getInstance("NONEwithEdDSA", (Provider)new EdDSASecurityProvider());
            signature.initSign(this.privateKey);
            signature.update(md.digest());
            return Hex.encodeHexString((byte[])signature.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String sign(String dataString) {
        return this.sign(dataString.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String sign(String data, RSASignaturePadding padding) {
        return this.sign(data);
    }

    @Override
    public String sign(byte[] data, RSASignaturePadding padding) {
        return this.sign(data);
    }

    @Override
    public boolean verify(String signature, byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            byte[] signatureBytes = Hex.decodeHex((String)signature);
            Signature eddsa = Signature.getInstance("NONEwithEdDSA", (Provider)new EdDSASecurityProvider());
            eddsa.initVerify(this.publicKey);
            eddsa.update(md.digest());
            return eddsa.verify(signatureBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean verify(String signature, String dataString, RSASignaturePadding padding) {
        return this.verify(signature, dataString.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean verify(String signature, String dataString) {
        return this.verify(signature, dataString.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean verify(String signature, byte[] data, RSASignaturePadding padding) {
        return this.verify(signature, data);
    }
}

