/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.enums;

import java.util.stream.Stream;

public enum KeyType {
    RSA("rsa"),
    ECDSA("ecdsa"),
    EdDSA("ed25519");

    private String type;

    public static KeyType getByType(String keyType) {
        return Stream.of(KeyType.values()).filter(val -> val.getType().equalsIgnoreCase(keyType)).findFirst().orElse(null);
    }

    public String getType() {
        return this.type;
    }

    private KeyType(String type) {
        this.type = type;
    }
}

