/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.blockchaininfo.dto.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.remme.java.blockchaininfo.dto.query.BaseQuery;
import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.error.RemmeValidationException;

public class StateQuery
extends BaseQuery {
    private String address;

    public StateQuery(String head, Integer limit, Object start, Object reverse, RemmeFamilyName familyName, String address) {
        super(head, start, limit, reverse, familyName);
        this.address = address;
    }

    @JsonProperty(value="address")
    public void setAddress(String address) {
        if (address != null) {
            if (!address.matches("^[a-f0-9]{70}$")) {
                throw new RemmeValidationException("Parameter 'address' is not valid");
            }
            this.address = address;
        }
    }

    public static StateQueryBuilder builder() {
        return new StateQueryBuilder();
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateQuery)) {
            return false;
        }
        StateQuery other = (StateQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StateQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "StateQuery(address=" + this.getAddress() + ")";
    }

    public StateQuery(String address) {
        this.address = address;
    }

    public StateQuery() {
    }

    public static class StateQueryBuilder {
        private String head;
        private Integer limit;
        private Object start;
        private Object reverse;
        private RemmeFamilyName familyName;
        private String address;

        StateQueryBuilder() {
        }

        public StateQueryBuilder head(String head) {
            this.head = head;
            return this;
        }

        public StateQueryBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public StateQueryBuilder start(Object start) {
            this.start = start;
            return this;
        }

        public StateQueryBuilder reverse(Object reverse) {
            this.reverse = reverse;
            return this;
        }

        public StateQueryBuilder familyName(RemmeFamilyName familyName) {
            this.familyName = familyName;
            return this;
        }

        public StateQueryBuilder address(String address) {
            this.address = address;
            return this;
        }

        public StateQuery build() {
            return new StateQuery(this.head, this.limit, this.start, this.reverse, this.familyName, this.address);
        }

        public String toString() {
            return "StateQuery.StateQueryBuilder(head=" + this.head + ", limit=" + this.limit + ", start=" + this.start + ", reverse=" + this.reverse + ", familyName=" + (Object)((Object)this.familyName) + ", address=" + this.address + ")";
        }
    }
}

