/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.blockchaininfo;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import io.remme.java.api.IRemmeApi;
import io.remme.java.blockchaininfo.IRemmeBlockchainInfo;
import io.remme.java.blockchaininfo.dto.BlockInfo;
import io.remme.java.blockchaininfo.dto.NetworkStatus;
import io.remme.java.blockchaininfo.dto.PeerList;
import io.remme.java.blockchaininfo.dto.batches.Batch;
import io.remme.java.blockchaininfo.dto.batches.BatchList;
import io.remme.java.blockchaininfo.dto.blocks.Block;
import io.remme.java.blockchaininfo.dto.blocks.BlockList;
import io.remme.java.blockchaininfo.dto.query.BaseQuery;
import io.remme.java.blockchaininfo.dto.query.BaseQueryRequest;
import io.remme.java.blockchaininfo.dto.query.StateQuery;
import io.remme.java.blockchaininfo.dto.query.StateQueryRequest;
import io.remme.java.blockchaininfo.dto.state.State;
import io.remme.java.blockchaininfo.dto.state.StateList;
import io.remme.java.blockchaininfo.dto.transactions.Transaction;
import io.remme.java.blockchaininfo.dto.transactions.TransactionData;
import io.remme.java.blockchaininfo.dto.transactions.TransactionHeader;
import io.remme.java.blockchaininfo.dto.transactions.TransactionList;
import io.remme.java.enums.Patterns;
import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.enums.RemmeMethod;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.protobuf.AccountOuterClass;
import io.remme.java.protobuf.AtomicSwap;
import io.remme.java.protobuf.PubKey;
import io.remme.java.protobuf.Transaction;
import io.remme.java.utils.RemmeExecutorService;
import io.remme.java.websocket.dto.RemmeRequestParams;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.codec.binary.Base64;

public class RemmeBlockchainInfo
implements IRemmeBlockchainInfo {
    private IRemmeApi remmeApi;
    private static Map<String, ParserEntity> address = new HashMap<String, ParserEntity>();
    private static Map<RemmeFamilyName, Map<Integer, ParserEntity>> correspond;

    private void checkId(String id) {
        if (id == null || id.isEmpty() || !id.matches(Patterns.HEADER_SIGNATURE.getPattern())) {
            throw new RemmeValidationException("Given 'id' is not valid");
        }
    }

    private void checkAddress(String address) {
        if (address == null || address.isEmpty() || !address.matches(Patterns.ADDRESS.getPattern())) {
            throw new RemmeValidationException("Given 'address' is not valid");
        }
    }

    public RemmeBlockchainInfo(IRemmeApi remmeApi) {
        this.remmeApi = remmeApi;
    }

    @Override
    public Future<BlockList> getBlocks(BaseQuery query) {
        if (query != null && query.getStart() instanceof Integer) {
            String temp = "0000000000000000" + new BigInteger(String.valueOf(query.getStart())).toString(16);
            query.setStart("0x" + temp.substring(temp.length() - 16));
        }
        return this.remmeApi.sendRequest(RemmeMethod.BLOCKS, new BaseQueryRequest(query), BlockList.class);
    }

    @Override
    public Future<Block> getBlockById(String id) {
        this.checkId(id);
        return this.remmeApi.sendRequest(RemmeMethod.FETCH_BLOCK, RemmeRequestParams.builder().id(id).build(), Block.class);
    }

    @Override
    public Future<BlockInfo[]> getBlockInfo(BaseQuery query) {
        ExecutorService es = RemmeExecutorService.getInstance();
        return es.submit(() -> {
            try {
                BlockInfo[] blocks = this.remmeApi.sendRequest(RemmeMethod.BLOCK_INFO, query, BlockInfo[].class).get();
                if (blocks == null) {
                    throw new RemmeValidationException("Unknown error occurs in the server");
                }
                return blocks;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Future<BatchList> getBatches(BaseQuery query) {
        return this.remmeApi.sendRequest(RemmeMethod.BATCHES, new BaseQueryRequest(query), BatchList.class);
    }

    @Override
    public Future<Batch> getBatchById(String id) {
        this.checkId(id);
        return this.remmeApi.sendRequest(RemmeMethod.FETCH_BATCH, RemmeRequestParams.builder().id(id).build(), Batch.class);
    }

    @Override
    public Future<String> getBatchStatus(String id) {
        this.checkId(id);
        return this.remmeApi.sendRequest(RemmeMethod.BATCH_STATUS, RemmeRequestParams.builder().id(id).build(), String.class);
    }

    @Override
    public Future<StateList> getState(StateQuery query) {
        return this.remmeApi.sendRequest(RemmeMethod.STATE, new StateQueryRequest(query), StateList.class);
    }

    @Override
    public Future<State> getStateByAddress(String address) {
        this.checkAddress(address);
        return this.remmeApi.sendRequest(RemmeMethod.FETCH_STATE, RemmeRequestParams.builder().address(address).build(), State.class);
    }

    @Override
    public Object parseStateData(State state) {
        try {
            if (state.getAddress() == null || state.getAddress().isEmpty()) {
                throw new RemmeValidationException("State should have address for parsing");
            }
            if (address.containsKey(state.getAddress().substring(0, 6))) {
                ParserEntity parserEntity = address.get(state.getAddress().substring(0, 6));
                return new ParsedData(parserEntity.getType(), parserEntity.getParser().parseFrom(Base64.decodeBase64((String)((String)state.getData()))));
            }
            throw new RemmeValidationException("This address " + state.getAddress() + " don't supported for parsing");
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<TransactionList> getTransactions(BaseQuery query) {
        return this.remmeApi.sendRequest(RemmeMethod.TRANSACTIONS, new BaseQueryRequest(query), TransactionList.class);
    }

    @Override
    public Future<Transaction> getTransactionById(String id) {
        this.checkId(id);
        return this.remmeApi.sendRequest(RemmeMethod.FETCH_TRANSACTION, RemmeRequestParams.builder().id(id).build(), Transaction.class);
    }

    @Override
    public Object parseTransactionPayload(TransactionData transaction) {
        try {
            RemmeFamilyName familyName = RemmeFamilyName.getByName(((TransactionHeader)transaction.getHeader()).getFamily_name());
            if (familyName != null && correspond.containsKey((Object)familyName)) {
                Transaction.TransactionPayload payload = (Transaction.TransactionPayload)Transaction.TransactionPayload.parser().parseFrom(Base64.decodeBase64((String)transaction.getPayload()));
                ParserEntity parserEntity = correspond.get((Object)familyName).get(payload.getMethod());
                return new ParsedData(parserEntity.getType(), parserEntity.getParser().parseFrom(payload.getData()));
            }
            throw new RemmeValidationException("This family name (" + ((TransactionHeader)transaction.getHeader()).getFamily_name() + ") don't supported for parsing");
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<NetworkStatus> getNetworkStatus() {
        return this.remmeApi.sendRequest(RemmeMethod.NETWORK_STATUS, NetworkStatus.class);
    }

    @Override
    public Future<String[]> getPeers() {
        ExecutorService es = RemmeExecutorService.getInstance();
        return es.submit(() -> this.remmeApi.sendRequest(RemmeMethod.PEERS, PeerList.class).get().getData());
    }

    static {
        address.put(RemmeFamilyName.SWAP.getNamespace(), new ParserEntity("info atomic swap", AtomicSwap.AtomicSwapInfo.parser()));
        address.put(RemmeFamilyName.ACCOUNT.getNamespace(), new ParserEntity("account", AccountOuterClass.Account.parser()));
        address.put(RemmeFamilyName.PUBLIC_KEY.getNamespace(), new ParserEntity("storage public key", PubKey.PubKeyStorage.parser()));
        correspond = new HashMap<RemmeFamilyName, Map<Integer, ParserEntity>>();
        HashMap<Integer, ParserEntity> swapMethods = new HashMap<Integer, ParserEntity>();
        swapMethods.put(0, new ParserEntity("atomic-swap-init", AtomicSwap.AtomicSwapInitPayload.parser()));
        swapMethods.put(1, new ParserEntity("atomic-swap-approve", AtomicSwap.AtomicSwapApprovePayload.parser()));
        swapMethods.put(2, new ParserEntity("atomic-swap-expire", AtomicSwap.AtomicSwapExpirePayload.parser()));
        swapMethods.put(3, new ParserEntity("atomic-swap-set-secret-lock", AtomicSwap.AtomicSwapSetSecretLockPayload.parser()));
        swapMethods.put(4, new ParserEntity("atomic-swap-close", AtomicSwap.AtomicSwapClosePayload.parser()));
        correspond.put(RemmeFamilyName.SWAP, swapMethods);
        HashMap<Integer, ParserEntity> accountMethods = new HashMap<Integer, ParserEntity>();
        accountMethods.put(0, new ParserEntity("transfer token", AccountOuterClass.TransferPayload.parser()));
        accountMethods.put(1, new ParserEntity("genesis", AccountOuterClass.GenesisPayload.parser()));
        correspond.put(RemmeFamilyName.ACCOUNT, accountMethods);
        HashMap<Integer, ParserEntity> pubKeyMethods = new HashMap<Integer, ParserEntity>();
        pubKeyMethods.put(0, new ParserEntity("store public key", PubKey.NewPubKeyPayload.parser()));
        pubKeyMethods.put(1, new ParserEntity("revoke public key", PubKey.RevokePubKeyPayload.parser()));
        correspond.put(RemmeFamilyName.PUBLIC_KEY, pubKeyMethods);
    }

    public static class ParsedData {
        private String type;
        private Object data;

        public String getType() {
            return this.type;
        }

        public Object getData() {
            return this.data;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParsedData)) {
                return false;
            }
            ParsedData other = (ParsedData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParsedData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "RemmeBlockchainInfo.ParsedData(type=" + this.getType() + ", data=" + this.getData() + ")";
        }

        public ParsedData(String type, Object data) {
            this.type = type;
            this.data = data;
        }

        public ParsedData() {
        }
    }

    public static class ParserEntity {
        private String type;
        private Parser<?> parser;

        public String getType() {
            return this.type;
        }

        public Parser<?> getParser() {
            return this.parser;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setParser(Parser<?> parser) {
            this.parser = parser;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParserEntity)) {
                return false;
            }
            ParserEntity other = (ParserEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Parser<?> this$parser = this.getParser();
            Parser<?> other$parser = other.getParser();
            return !(this$parser == null ? other$parser != null : !this$parser.equals(other$parser));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParserEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Parser<?> $parser = this.getParser();
            result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
            return result;
        }

        public String toString() {
            return "RemmeBlockchainInfo.ParserEntity(type=" + this.getType() + ", parser=" + this.getParser() + ")";
        }

        public ParserEntity(String type, Parser<?> parser) {
            this.type = type;
            this.parser = parser;
        }

        public ParserEntity() {
        }
    }
}

