/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.atomicswap.dto;

import io.remme.java.error.RemmeValidationException;

public class SwapInitDTO {
    private String receiverAddress;
    private String senderAddressNonLocal;
    private Long amount;
    private String swapId;
    private String secretLockBySolicitor;
    private String emailAddressEncryptedByInitiator;
    private Integer createdAt;

    public void setReceiverAddress(String receiverAddress) {
        if (receiverAddress == null || receiverAddress.isEmpty() || !receiverAddress.matches("^[0-9a-f]{70}$")) {
            throw new RemmeValidationException("receiverAddress is not valid or not specified");
        }
        this.receiverAddress = receiverAddress;
    }

    public void setSecretLockBySolicitor(String secretLockBySolicitor) {
        if (secretLockBySolicitor != null && !secretLockBySolicitor.isEmpty()) {
            if (secretLockBySolicitor.matches("^[0-9a-f]{64}$")) {
                this.secretLockBySolicitor = secretLockBySolicitor;
            } else {
                throw new RemmeValidationException("secretLockBySolicitor is not a valid");
            }
        }
    }

    public void setSwapId(String swapId) {
        if (swapId == null || swapId.isEmpty() || !swapId.matches("^[0-9a-f]{64}$")) {
            throw new RemmeValidationException("swapId is not a valid or not specified");
        }
        this.swapId = swapId;
    }

    public void setAmount(Long amount) {
        if (amount == null) {
            throw new RemmeValidationException("amount is not specified");
        }
        this.amount = amount;
    }

    public void setSenderAddressNonLocal(String senderAddressNonLocal) {
        if (senderAddressNonLocal == null || senderAddressNonLocal.isEmpty()) {
            throw new RemmeValidationException("senderAddressNonLocal is not specified");
        }
        this.senderAddressNonLocal = senderAddressNonLocal;
    }

    public void setCreatedAt(Integer createdAt) {
        if (createdAt == null) {
            throw new RemmeValidationException("createdAt is not specified");
        }
        this.createdAt = createdAt;
    }

    public static SwapInitDTOBuilder builder() {
        return new SwapInitDTOBuilder();
    }

    public String getReceiverAddress() {
        return this.receiverAddress;
    }

    public String getSenderAddressNonLocal() {
        return this.senderAddressNonLocal;
    }

    public Long getAmount() {
        return this.amount;
    }

    public String getSwapId() {
        return this.swapId;
    }

    public String getSecretLockBySolicitor() {
        return this.secretLockBySolicitor;
    }

    public String getEmailAddressEncryptedByInitiator() {
        return this.emailAddressEncryptedByInitiator;
    }

    public Integer getCreatedAt() {
        return this.createdAt;
    }

    public void setEmailAddressEncryptedByInitiator(String emailAddressEncryptedByInitiator) {
        this.emailAddressEncryptedByInitiator = emailAddressEncryptedByInitiator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwapInitDTO)) {
            return false;
        }
        SwapInitDTO other = (SwapInitDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$receiverAddress = this.getReceiverAddress();
        String other$receiverAddress = other.getReceiverAddress();
        if (this$receiverAddress == null ? other$receiverAddress != null : !this$receiverAddress.equals(other$receiverAddress)) {
            return false;
        }
        String this$senderAddressNonLocal = this.getSenderAddressNonLocal();
        String other$senderAddressNonLocal = other.getSenderAddressNonLocal();
        if (this$senderAddressNonLocal == null ? other$senderAddressNonLocal != null : !this$senderAddressNonLocal.equals(other$senderAddressNonLocal)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$swapId = this.getSwapId();
        String other$swapId = other.getSwapId();
        if (this$swapId == null ? other$swapId != null : !this$swapId.equals(other$swapId)) {
            return false;
        }
        String this$secretLockBySolicitor = this.getSecretLockBySolicitor();
        String other$secretLockBySolicitor = other.getSecretLockBySolicitor();
        if (this$secretLockBySolicitor == null ? other$secretLockBySolicitor != null : !this$secretLockBySolicitor.equals(other$secretLockBySolicitor)) {
            return false;
        }
        String this$emailAddressEncryptedByInitiator = this.getEmailAddressEncryptedByInitiator();
        String other$emailAddressEncryptedByInitiator = other.getEmailAddressEncryptedByInitiator();
        if (this$emailAddressEncryptedByInitiator == null ? other$emailAddressEncryptedByInitiator != null : !this$emailAddressEncryptedByInitiator.equals(other$emailAddressEncryptedByInitiator)) {
            return false;
        }
        Integer this$createdAt = this.getCreatedAt();
        Integer other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SwapInitDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $receiverAddress = this.getReceiverAddress();
        result = result * 59 + ($receiverAddress == null ? 43 : $receiverAddress.hashCode());
        String $senderAddressNonLocal = this.getSenderAddressNonLocal();
        result = result * 59 + ($senderAddressNonLocal == null ? 43 : $senderAddressNonLocal.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $swapId = this.getSwapId();
        result = result * 59 + ($swapId == null ? 43 : $swapId.hashCode());
        String $secretLockBySolicitor = this.getSecretLockBySolicitor();
        result = result * 59 + ($secretLockBySolicitor == null ? 43 : $secretLockBySolicitor.hashCode());
        String $emailAddressEncryptedByInitiator = this.getEmailAddressEncryptedByInitiator();
        result = result * 59 + ($emailAddressEncryptedByInitiator == null ? 43 : $emailAddressEncryptedByInitiator.hashCode());
        Integer $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "SwapInitDTO(receiverAddress=" + this.getReceiverAddress() + ", senderAddressNonLocal=" + this.getSenderAddressNonLocal() + ", amount=" + this.getAmount() + ", swapId=" + this.getSwapId() + ", secretLockBySolicitor=" + this.getSecretLockBySolicitor() + ", emailAddressEncryptedByInitiator=" + this.getEmailAddressEncryptedByInitiator() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    public SwapInitDTO(String receiverAddress, String senderAddressNonLocal, Long amount, String swapId, String secretLockBySolicitor, String emailAddressEncryptedByInitiator, Integer createdAt) {
        this.receiverAddress = receiverAddress;
        this.senderAddressNonLocal = senderAddressNonLocal;
        this.amount = amount;
        this.swapId = swapId;
        this.secretLockBySolicitor = secretLockBySolicitor;
        this.emailAddressEncryptedByInitiator = emailAddressEncryptedByInitiator;
        this.createdAt = createdAt;
    }

    public SwapInitDTO() {
    }

    public static class SwapInitDTOBuilder {
        private String receiverAddress;
        private String senderAddressNonLocal;
        private Long amount;
        private String swapId;
        private String secretLockBySolicitor;
        private String emailAddressEncryptedByInitiator;
        private Integer createdAt;

        SwapInitDTOBuilder() {
        }

        public SwapInitDTOBuilder receiverAddress(String receiverAddress) {
            this.receiverAddress = receiverAddress;
            return this;
        }

        public SwapInitDTOBuilder senderAddressNonLocal(String senderAddressNonLocal) {
            this.senderAddressNonLocal = senderAddressNonLocal;
            return this;
        }

        public SwapInitDTOBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public SwapInitDTOBuilder swapId(String swapId) {
            this.swapId = swapId;
            return this;
        }

        public SwapInitDTOBuilder secretLockBySolicitor(String secretLockBySolicitor) {
            this.secretLockBySolicitor = secretLockBySolicitor;
            return this;
        }

        public SwapInitDTOBuilder emailAddressEncryptedByInitiator(String emailAddressEncryptedByInitiator) {
            this.emailAddressEncryptedByInitiator = emailAddressEncryptedByInitiator;
            return this;
        }

        public SwapInitDTOBuilder createdAt(Integer createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SwapInitDTO build() {
            return new SwapInitDTO(this.receiverAddress, this.senderAddressNonLocal, this.amount, this.swapId, this.secretLockBySolicitor, this.emailAddressEncryptedByInitiator, this.createdAt);
        }

        public String toString() {
            return "SwapInitDTO.SwapInitDTOBuilder(receiverAddress=" + this.receiverAddress + ", senderAddressNonLocal=" + this.senderAddressNonLocal + ", amount=" + this.amount + ", swapId=" + this.swapId + ", secretLockBySolicitor=" + this.secretLockBySolicitor + ", emailAddressEncryptedByInitiator=" + this.emailAddressEncryptedByInitiator + ", createdAt=" + this.createdAt + ")";
        }
    }
}

