/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.httpd;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/28
 */
public final class HTTPUtils {

	private static final String MSG200 =
			"HTTP/1.0 200 OK\r\n";
	private static final String MSG400 =
			"HTTP/1.0 400 Bad Request\r\n";
	private static final String MSG404 =
			"HTTP/1.0 404 Not Found\r\n";
	private static final String MSG500 =
			"HTTP/1.0 500 Internal Error\r\n";

	static final Ecrire MESSAGE400 = new Ecrire() {

		@Override
		public void write(SocketChannel c) throws IOException {
			HTTPUtils.putBadRequest(c);
			c.close();
		}

	};

	static final Ecrire MESSAGE404 = new Ecrire() {

		@Override
		public void write(SocketChannel c) throws IOException {
			HTTPUtils.putNotFound(c);
			c.close();
		}

	};

	static final Ecrire MESSAGE500 = new Ecrire() {

		@Override
		public void write(SocketChannel c) throws IOException {
			HTTPUtils.putBadRequest(c);
			c.close();
		}

	};

	private HTTPUtils() {}

	public static void puterror(SocketChannel c,
			Throwable e) throws IOException {
		c.write(ByteBuffer.wrap(MSG500.getBytes()));
	}

	public static void putApplicationError(PrintWriter w,
			Throwable e) throws IOException {
		w.println("<html>");
		w.println("<head>");
		w.println("<title>500 Internal Error</title>");
		w.println("</head>");
		w.println("<body>");
		w.println("<h1>500 Internal Error</h1>");
		w.println("<pre>");
		e.printStackTrace(w);
		w.println("</pre>");
		w.println("</body>");
		w.println("</html>");
	}

	public static void putOk(SocketChannel c) throws IOException {
		c.write(ByteBuffer.wrap(MSG200.getBytes()));
	}

	public static void putBadRequest(SocketChannel c) throws IOException {
		c.write(ByteBuffer.wrap(MSG400.getBytes()));
	}

	public static void putNotFound(SocketChannel c) throws IOException {
		c.write(ByteBuffer.wrap(MSG404.getBytes()));
	}

	public static void put(SocketChannel c,
			String s) throws IOException {
		c.write(ByteBuffer.wrap(s.getBytes()));
	}

}
