/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.httpd;

import java.text.SimpleDateFormat;
import java.util.logging.Level;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/28
 */
public class HTTPLoggerFactory {

	static class L extends HTTPLogger {

		public void log(Level l, String format, Object... os) {
			java.util.Date d;

			if(level.intValue() > l.intValue()) {
				// do nothing
			} else {
				d = new java.util.Date();
				System.err.print(FMT.format(d));
				System.err.print(" :");
				System.err.print(l.toString());
				System.err.print(" :");
				System.err.format(format, os);
				System.err.println();
			}
		}

	};

	private static final SimpleDateFormat FMT =
			new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

	private static HTTPLogger log = new L();

	/**
	 * 
	 * @return
	 */
	public static HTTPLogger getInstance() {
		return log;
	}

}
