/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.httpd;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharsetEncoder;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/28
 */
public class DynamicEcrire implements Ecrire {

	private HTTPDispatch dispatch;
	private HTTPRequest request;
	private Class<?> classe;

	/**
	 * 
	 * @param d
	 * @param q
	 * @param k
	 */
	public DynamicEcrire(HTTPDispatch d, HTTPRequest q, Class<?> k) {
		dispatch = d;
		request = q;
		classe = k;
	}

	@Override
	public void write(SocketChannel c) throws IOException {
		PrintWriter p = null;
		CharsetEncoder o;
		Method t;

		o = dispatch.getCharset().newEncoder();
		p = new PrintWriter(Channels.newWriter(c, o, -1));
		try {
			HTTPServer.log.finest("DynamicEcrire");
			t = classe.getMethod("execute", HTTPRequest.class,
					PrintWriter.class);
			HTTPUtils.putOk(c);
			HTTPUtils.put(c, o.toString());
			HTTPUtils.put(c, "\r\n\r\n");
			t.invoke(dispatch, request, p);
		} catch(SecurityException e) {
			HTTPServer.log.finest("exception write(): %s",
					e.toString());
			HTTPUtils.puterror(c, e);
		} catch(NoSuchMethodException e) {
			HTTPServer.log.finest("exception write(): %s",
					e.toString());
			HTTPUtils.puterror(c, e);
		} catch(IllegalArgumentException e) {
			HTTPServer.log.finest("exception write(): %s",
					e.toString());
			HTTPUtils.puterror(c, e);
		} catch(IllegalAccessException e) {
			HTTPServer.log.finest("exception write(): %s",
					e.toString());
			HTTPUtils.puterror(c, e);
		} catch(InvocationTargetException e) {
			HTTPServer.log.finest("exception write(): %s",
					e.toString());
			HTTPUtils.putApplicationError(p, e.getCause());
		} finally {
			p.flush();
		}
	}

}
