/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.parser.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.morilib.parser.csv.CSVConfig;
import net.morilib.parser.csv.CSVException;
import net.morilib.parser.csv.CSVHandler;
import net.morilib.parser.csv.CSVParseException;
import net.morilib.parser.csv.CSVParserContinuation;
import net.morilib.parser.csv.CSVPullParser;
import net.morilib.parser.csv.CSVPushParser;
import net.morilib.parser.csv.SimpleCSVPushParser;

public final class StringCSVPullParser
implements CSVPullParser<String[]>,
Closeable {
    private static final CSVParserContinuation MARKER = new CSVParserContinuation(){};
    private final Hndl handler = new Hndl();
    private CSVPushParser parser;
    private CSVParserContinuation cont = MARKER;
    private List<String> toreturn;
    private Reader stream;

    public StringCSVPullParser(Reader rd, CSVConfig f) {
        this.parser = new SimpleCSVPushParser(this.handler, f);
        this.stream = rd;
    }

    @Override
    public String[] get() {
        return this.toreturn.toArray(new String[0]);
    }

    @Override
    public boolean next() throws CSVException, IOException {
        if (this.cont == null) {
            throw new NoSuchElementException();
        }
        try {
            CSVParserContinuation cSVParserContinuation = this.cont = this.cont == MARKER ? this.parser.parse(this.stream) : this.parser.parse(this.cont);
            if (this.cont == null) {
                this.stream.close();
                this.stream = null;
                return false;
            }
            return true;
        }
        catch (CSVException e) {
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
            this.cont = null;
        }
    }

    private class Hndl
    implements CSVHandler {
        private Hndl() {
        }

        @Override
        public boolean startFile() throws CSVException {
            return false;
        }

        @Override
        public boolean endFile() throws CSVException {
            return false;
        }

        @Override
        public boolean startLine(int line) throws CSVException {
            StringCSVPullParser.this.toreturn = new ArrayList();
            return false;
        }

        @Override
        public boolean endLine(int line) throws CSVException {
            return true;
        }

        @Override
        public boolean emptyLine(int line) throws CSVException {
            return false;
        }

        @Override
        public boolean element(String elm, int line, int field) throws CSVException {
            StringCSVPullParser.this.toreturn.add(elm);
            return false;
        }

        @Override
        public boolean comment(String com, int line) throws CSVException {
            return false;
        }

        @Override
        public boolean error(CSVParseException e) throws CSVException {
            throw e;
        }
    }
}

