/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.httpd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.httpd.HTTPRequest;
import net.morilib.httpd.URLEncodedInputStream;

public class HTTPRequestContinuableParser {
    private static Pattern PTN = Pattern.compile("([A-Z]+) +([^ ]+) +HTTP/([01].[0-9])");
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private URLEncodedInputStream ins;
    private StringBuffer buf = new StringBuffer();
    private Matcher match = null;
    private String key = null;
    private String val = null;
    private Charset enc;
    private S state = S.INIT;
    private int etat = 0;

    public HTTPRequestContinuableParser(Charset encoding) {
        this.ins = new URLEncodedInputStream();
        this.enc = encoding;
    }

    private void completeString() throws IOException {
        String s = this.buf.toString();
        this.match = PTN.matcher(s = new String(s.getBytes("ISO-8859-1"), this.enc));
        if (!this.match.matches()) {
            throw new IOException();
        }
        this.buf = new StringBuffer();
        this.etat = 0;
    }

    boolean readString() throws IOException {
        if (this.ins == null) {
            throw new IOException();
        }
        int c;
        while ((c = this.ins.read()) >= 0) {
            switch (this.etat) {
                case 13: {
                    if (c == 10) {
                        this.completeString();
                        this.state = S.HEAD;
                        return true;
                    }
                    this.buf.append(this.etat).appendCodePoint(c);
                    break;
                }
                default: {
                    if (c == 13) break;
                    this.buf.appendCodePoint(c);
                }
            }
            this.etat = c;
        }
        return false;
    }

    private boolean completeHeader() throws IOException {
        if (this.key != null) {
            this.val = this.buf.toString().trim();
        } else if (this.buf.length() > 0) {
            this.key = this.buf.toString().trim();
        } else {
            if (this.match.group(1).equals("POST")) {
                this.state = S.POST;
                this.etat = 0;
                return true;
            }
            this.state = S.DONE;
            this.etat = 0;
            return true;
        }
        this.headers.put(this.key, this.val);
        this.val = null;
        this.key = null;
        this.buf = new StringBuffer();
        return false;
    }

    boolean readHeader() throws IOException {
        if (this.ins == null) {
            this.state = S.DONE;
            return false;
        }
        int c;
        while ((c = this.ins.read()) >= 0) {
            switch (this.etat) {
                case 13: {
                    if (c != 10) {
                        this.buf.appendCodePoint(this.etat).appendCodePoint(c);
                        break;
                    }
                    if (!this.completeHeader()) break;
                    return true;
                }
                case 58: {
                    if (this.key == null) {
                        this.key = this.buf.toString().trim();
                        this.buf = new StringBuffer();
                    }
                    this.buf.appendCodePoint(c);
                    break;
                }
                default: {
                    if (c == 13 || c == 58 && this.key == null) break;
                    this.buf.appendCodePoint(c);
                }
            }
            this.etat = c;
        }
        return false;
    }

    private boolean completeParameters() throws IOException {
        if (this.key != null) {
            this.val = this.buf.toString().trim();
        } else if (this.buf.length() > 0) {
            this.key = this.buf.toString().trim();
        } else {
            this.state = S.DONE;
            this.etat = 0;
            return true;
        }
        this.parameters.put(this.key, this.val == null ? "" : this.val);
        this.val = null;
        this.key = null;
        this.buf = new StringBuffer();
        return false;
    }

    boolean readParameters() throws IOException {
        int c;
        while ((c = this.ins.read()) >= 0) {
            switch (this.etat) {
                case 13: {
                    if (c != 10) {
                        this.buf.appendCodePoint(this.etat).appendCodePoint(c);
                        break;
                    }
                    if (!this.completeParameters()) break;
                    return true;
                }
                case 61: {
                    if (this.key == null) {
                        this.key = this.buf.toString().trim();
                        this.buf = new StringBuffer();
                    }
                    this.buf.appendCodePoint(c);
                    break;
                }
                case 38: {
                    if (this.key != null) {
                        this.val = this.buf.toString().trim();
                    } else {
                        this.key = this.buf.toString().trim();
                    }
                    this.parameters.put(this.key, this.val == null ? "" : this.val);
                    this.val = null;
                    this.key = null;
                    this.buf = new StringBuffer().appendCodePoint(c);
                    break;
                }
                default: {
                    if (c == 13 || c == 38 || c == 61) break;
                    this.buf.appendCodePoint(c);
                }
            }
            this.etat = c;
        }
        return false;
    }

    public boolean isDone() {
        return this.state.equals((Object)S.DONE);
    }

    public HTTPRequest getRequest() throws IOException {
        switch (this.state) {
            case INIT: {
                this.completeString();
                break;
            }
            case HEAD: {
                this.completeHeader();
                break;
            }
            case POST: {
                this.completeParameters();
                break;
            }
        }
        this.state = S.DONE;
        return new HTTPRequest(this.match.group(1), this.match.group(2), this.match.group(3), this.headers, this.parameters);
    }

    /*
     * Unable to fully structure code
     */
    public void readPartial(InputStream in) throws IOException {
        b = true;
        this.ins.newInputStream(in);
        while (b) {
            switch (HTTPRequestContinuableParser.$SWITCH_TABLE$net$morilib$httpd$HTTPRequestContinuableParser$S()[this.state.ordinal()]) {
                case 1: {
                    b = this.readString();
                    break;
                }
                case 2: {
                    b = this.readHeader();
                    break;
                }
                case 3: {
                    b = this.readParameters();
                    break;
                }
lbl14:
                // 2 sources

                case 4: {
                    if (this.ins.read() >= 0) ** GOTO lbl14
                    return;
                }
            }
        }
    }

    private static enum S {
        INIT,
        HEAD,
        POST,
        DONE;

    }
}

